
; Arriving here it verified we are mounting a DiskDISK for volume 1.
; Move DCT from DD header to drive 1 DCT.
; Move file type from volbuf to datatyp$ in menu.

; Pointers built in storage driver already point to correct place for diskdisk.
; DiskDISK header still resides in volbuf.

; Mounted drive has been determined to be DISKDisk.
; Sector 0 of DISKDisk file is still in volbuf. 
; Recover DCT for this drive and copy to system DCT1$.
; Also set main menu to show DISKDisk type for this volume.

dskdsk		MVC		volbuf,datatyp$,8	; Copy name of DiskDISK volume to menu.
		MVC		volbuf+11,DCT1$+3,7	; Recover DCT settings for this DiskDISK volume to DCT 1.
	
		ld		a,(DCT1$+4)		; Drive 1.
		and		0F0h			; Strip out drive select bits.
		set		0,a			; Make this drive #1.
		set		4,a			; Tell world this is an alien controller.
		set		6,a			; Capable of double density.
		ld		(DCT1$+4),a

		xor		a			; Update DCT, its way it is on real model 4.
		ld		(DCT1$+5),a		; Cylinder=0.

; Now read track=0 sector=0 of drive=1 & recover pointer to directory cylinder.

		ld		iy,DCT1$		; dct1.
		LD		HL,volbuf		; HL points to buffer of READ.
		ld		d,0			; D=> Track 0.
		ld		e,0			; E=> Sector 0.
		ld		c,1			; C=> C contains drive #1.
		ld		b,9			; B=> Function in register B.
		call		FDCDVR			; Call driver.

; Get pointer to directory and place in DCT1 directory pointer.

		ld		a,(volbuf+2)		; Sector 0 of a drive image is on volbuf.
		ld		(DCT1$+9),a		; Point DCT to true directory cylinder.

; Now read directory as pointed to by recovered directory cylinder pointer.

; Now read 1st sector of directory.

get1dir		ld		iy,DCT1$		; dct1.
		ld		a,(DCT1$+9)
		LD		HL,volbuf		; HL points to buffer of READ.
		ld		d,a			; D=> Track, A contains directory cylinder.
		ld		e,0			; E=> Sector 0.
		ld		c,1			; C=> C contains drive #1.
		ld		b,9			; B=> Function in register B.
		call		FDCDVR			; Call driver.

; Make sure driver reported error #6. 
; We are reading from directory thus driver should have generated error #6.
; Error #6 is normal, no error is abnormal.

		jr		z,$			; No error 6 means it was not a system sector.
		cp		6			; Error on reading system sector.
		call		nz,nodirectort1

; volbuf now contains GAT,--- first sector of directory.

		ld		a,(volbuf+0d0h)		; Get 1st char of volume name.
		or		a			; If filename starts with 00h then its bum steer.
		jp		z,switch_den		; Switch density then try getting again..
		ld		a,(volbuf+0cbh)		; Get version that formatted this volume.
		and		0F0h			; Strip of right hex digit.
		cp		060h			; Make sure this volume created by a DOS 6.x version.
		jr		z,setup_dct1		; If this volume formatted by DOS 6.x skip to setting up DCT
		cp		050h			; If not formatted by LSDOS 6.x was it 5.x?
		call		nz,not56fmt		; Report no system directory.
		jr		setup_dct1

switch_den	ld		bc,4511h		; Values needed to set double density.
		ld		(iy+7),c
		ld		(iy+8),b		; Tell OS this volume is formatted in double density. 

; Try getting first sector of directory again using double density.

		ld		iy,DCT1$		; dct1.
		ld		a,(DCT1$+9)
		LD		HL,volbuf		; HL points to buffer of READ.
		ld		d,a			; D=> Track, A contains directory cylinder.
		ld		e,0			; E=> Sector 0.
		ld		c,1			; C=> C contains drive #1.
		ld		b,9			; B=> Function in register B.
		call		FDCDVR			; Call driver.

; Make sure driver reported error #6. 
; We are reading from directory thus driver should have generated error #6.
; Error #6 is normal, no error is abnormal.

		jr		z,$			; No error 6 means it was not a system sector.
		cp		6			; Error on reading system sector.
		call		nz,nodirectort1

; volbuf now contains GAT,--- first sector of directory using double density settings.
; Test and see if we found true directory.

		ld		a,(volbuf+0d0h)		; Get 1st char of volume name.
		or		a			; If filename starts with 00h then its bum steer.
		call		z,nodirectort1		; Switch density then try getting again.

		ld		a,(volbuf+0cbh)		; Get version that formatted this volume.
		and		0F0h			; Strip of right hex digit.
		cp		060h			; Make sure this volume created by a DOS 6.x version.
		jr		z,setup_dct1		; This was formatted by LSDOS 6.x
		cp		050h			; If not formatted by LSDOS 6.x was it 5.x?
		call		nz,not56fmt		; Report if not formatted by DOS 5 or 6.

setup_dct1	ld		iy,DCT1$		; dct1.
		res		0,(iy+4)		; Not drive 0.
		set		1,(iy+4)		; Tell world this is drive 1.
		set		4,(iy+4)		; Tell world this is an alien controller.

		ld		a,(volbuf+0cch)		; Get logical cylinders in excess of 35.
		add		35			; Add 35 to get true cylinder count.
		push		af
		call		c,mounterr1		; Cannot overflow.
		pop		af
		dec		a			; max_cyl=max_cyl - 1.
		push		af
		call		c,mounterr1		; Cannot overflow.
		pop		af
		ld		(iy+6),a		; Make it highest sector per track.

		ld		a,(volbuf+0cdh)		; Get configuration byte.
		res		5,(IY+4)		; Set sides to 1.	
		bit		5,a			; Test number sides when formatted.
		jr		z,v0_mounted		; If <>0 then leave sides = 2.
		set		5,(IY+4)		; Make sides = 2.

v0_mounted	ld		d,(iy+6)		; Get max cylinders.
		inc		d			; Adjust +1.
		ld		a,(iy+7)		; Get config, lower nibble contains sec per trk.
		and		3Fh			; Get lower nibble containing sectors per trk.
		inc		a
		bit		5,(IY+4)		; Sides = 2?
		jr		z,notdbl		; If so then we double sectors per track.
		sla		a			; Sectors per track = sectors per track * 2.
notdbl		ld		e,a			; Setup to multiply track * sectors per track.
		MLT		DE			; we then multiply (# CYL * SEC per CYL) 16b result in DE.

; Following instruction changes to NOP if this is not a diskDISK image.

not_DD		inc		de			; Bump one sector higher to adjust for diskdisk header.



; Stuff Volume 1 size in main menu.
; Convert DE to 24 bit by  H=D, L=E, E=0    24 BIT--> E:HL.
; Store ASCII representation of 24 bit value in main memu.
; Convert to packed BCD.
; Convert packed BCD to unpacked.
; Convert unpacked to ASCII.
; Trim leading 0's away.
; Stuff all these results in main menu.

		push		de			; Save a copy of MLT results.
		ld		BC,datasiz$		; Address to store ASCII result in string.

		call		cvt_24_ascii		; Convert 24 bit value to ASCII & stuff in main menu.
