
		IN0	c,(UART1_RBR)			; GET char waiting.
		ld	(hl),c				; Store char.
		inc	hl
		LOOP	fdc_get_byte

		push	hl

		IN0    	A,(UART1_LSR)		; Char waiting?
		bit	1,a			; 1 or TRUE if yes.
		jr	nz,$
		bit	0,a			; 1 or TRUE if yes.
		jr	nz,$

		PUMP	DEVICE.console,fdc_eol

		ld	b,0
		pop	hl

fdc_dmp_sec	push 	bc
		ld	a,(hl)
		inc	hl
		GOSUB	fdc_cvt_ascii
		ld	a,d
		ld	(fdc_err_buff),a
		ld	a,e
		ld	(fdc_err_buff+1),a
		push	hl
		PUMP	DEVICE.console,fdc_err_buff
		pop	hl
		pop	bc
		djnz	fdc_dmp_sec

		PUMP	DEVICE.console,fdc_eol

fdc_getchar	IN0    	A,(UART0_LSR)				; Get status of data waiting?
		AND    	UART_DR     				; Char waiting?
		IF_EQ_BRANCH	fdc_getchar			; Make NZ, NO char waiting.
		IN0   	A,(UART0_RBR)				; Get byte from UART0.
;
fdc_cvt_ascii	ld	e,a
		and	0f0h					; Strip out upper 4 bits.
		rr	a
		rr	a
		rr	a
		rr	a
		and	0fh
		add	'0'
		cp	':'					; Is it >9
		IF_GT_GOTO	fdc_no_more2
		add	7					; Adjust for A-F
fdc_no_more2	ld	d,a
		ld	a,e
		and	0fh
		add	'0'
		cp	':'					; Is it >9
		IF_GT_GOTO	fdc_no_more1	
		add	7					; Adjust for A-F
fdc_no_more1	ld	e,a
		RETURN

fdc_eol		db	CR.asc,CR.asc,ETX.asc