INPUT_U.str 	MACRO	buffer,max	; Buffer and MAX chars to input.
		scope
		ld	hl,buffer
		ld	b,max		; Max number bytes to input.
		jr	$1		; Branch to beginning.

$2:		ld	c,a		; Output BS just received.
		CALL	TXUART0		; Send it.
		ld	c,SP.asc	; Now space out char we are deleting.
		CALL	TXUART0
		ld	c,BS.asc	; Backspace again to new location.
		CALL	TXUART0
		dec	hl		; Back pointer in buffer up by -1.
		pop	bc		; Recover B counter.
		INC	B
		cp	max
		jr	nc,$1
		ld	b,max

$1:		push	bc		; Save counter as other routines may clobber it.
		CALL	getchar		; Using UART NOT TRSDOS get one byte from UART0.
		CP	BS.asc		; Is is backspace?
		jr	z,$2		; If yes gp to backspace routine above.
		ld	(hl),a		; Put char in buff.
		inc	hl		; Bump pointer to next place in buffer.
		cp	CR.asc		; Was it a CR?
		jr	z,$4		; Exit input as terminalted by CR.
		ld	c,a
		CALL	TXUART0		; Output character.
$3		pop	bc		; Recover counter.
		djnz	$1		; Counter = counter - 1. If counter <> 0 branch $1.
		xor	a		; All is well set Z flag.
		jr	$5		; Finished, exit.
$4:		or	a		; Make it non zero.
$5:		endmac	INPUT_U.str	; MACRO is done.

KEY_U.get:	MACRO	dest
		call	getchar
		IFMA 	1
		ld	dest,a
		else
		ENDIF
		ENDMAC	KEY_U.get