BANK		MACRO		num
		ld		c,num
		ld		b,0
		SVC		svc_zbank
		ENDMAC		BANK
		
CKDRIVE		MACRO		drv,onerror
		ld		c,drv
		SVC		svc_ckdrv
		call		nz,onerror
		endmac		CKDRIVE
			
DCINIT:		MACRO		drive,inierr
		ld		c,drive
		SVC		svc_dcinit
		jp		nz,inierr
		ENDMAC		DCINIT

DCRESET		MACRO		drive
		ld		c,drive
		SVC		svc_dcres
		ENDMAC		DCRESET
		
DCSTATUS	MACRO		drive,onerror
		ld		c,drive
		SVC		svc_dcstat
		jp		nz,onerror
		ENDMAC		DCSTATUS
		
DISABLEVIDEO	MACRO	
		CALL		DIS_DO_RAM
		ENDMAC
			
ENABLEVIDEO	MACRO
		CALL		ENA_DO_RAM
		ENDMAC		

IPL		MACRO
		SVC		svc_ipl
		ENDMAC		IPL


MSG		MACRO		dat,device
		LD		DE,device
		LD		HL,dat
		SVC		svc_msg
		ENDMAC

PAUSE:		MACRO		wait
		ld		bc,wait
		SVC		svc_pause
		ENDMAC
			
PRT.msg:	MACRO		mess
		ld		hl,mess
		SVC		svc_printz
		ENDMAC		PRT.msg

PRT.char:	MACRO		txt
		ld		c,txt
		SVC		svc_prt
		ENDMAC		PRT.char

READ.dir	macro		fdec,drv,onerror		; Read directory entry code, on drive, if error goto.
		LD		a,fdec
		ld		b,a
		ld		c,drv
		SVC		svc_dirrd
		jp		nz,onerror
		endmac		READ.dir
		
READ.hdr	MACRO		buffer,drive
		LD		C,drive
		LD		HL,buffer
		SVC		svc_rdhdr
		ENDMAC
			
READ.sec	MACRO		buff,drive,cylinder,sector
		LD		HL,buff
		LD		D,cylinder
		LD		E,sector
		LD		C,drive
		SVC		svc_rdsec			;Read sector SVC049.
		ENDMAC
		
READ.ssc	MACRO		buffer,drive,cylinder,sector
	
; RDSSC svc_85 

; This SVC will read the directory system sector identified by the calling linkage.
; The cylinder number containing the directory that is loaded into register D is recovered from the Drive Control Table (DCT).
; The DCT for the each drive is obtained via the @GTDCT SVC.

; Registers Affected: AF.
; Entry: HL A pointer to the buffer to receive the sector of system data.
; D Contains the logical cylinder number to read (0-255).
; E Contains the logical sector number to read (0-255).
; C Contains the the logical drive number.

; Exit: A Passes the error return code if an error is encountered. 
;       Z Set if no error is encountered.


		ld		hl,buffer
		ld		d,cylinder
		ld		e,sector
		ld		c,drive
		SVC		svc_rdssc			; Read a system sector, SVC085.
		ENDMAC
			
RESELECT	MACRO	drive
		ld		c,drive
		SVC		svc_rslct
		ENDMAC
			
RESTORE0	MACRO	drive
		ld		c,drive
		SVC		svc_rstor
		ENDMAC

SVC		MACRO	num
		ld	a,num
		restart28
		ENDMAC	SVC
			
SCANKI		MACRO						;Scan KI device.
		SVC		svc_kbd
		ENDMAC
			
SEEKCYL		MACRO	drive,cylinder				; Seek to cylinder on drive.
		ld		c,drive
		ld		d,cylinder
		SVC		svc_seekcyl
		ENDMAC

SELECT		MACRO	drive,onerror				; Select drive.
		ld		c,drive
		SVC		svc_slct
		jp		nz,onerror
		ENDMAC


SOUND:		MACRO	tone,duration
		ld		b,duration|tone
		SVC		svc_sound
		ENDMAC
	
STEPIN		MACRO	drive
		ld		c,drive
		SVC		svc_stepi
		ENDMAC

VIEWDIR		MACRO	drive,buffer				; Send directory of drive to *do.
		ld		hl,buffer
		ld		b,0				; Display dir on *do.
		ld		c,drive
		SVC		svc_dodir
		ENDMAC	VIEWDIR
		
WRITESEC	MACRO	buffer,drive,cylinder,sector		; Write disc sector.
		ld		hl,buffer
		ld		c,drive
		ld		d,cylinder
		ld		e,sector			
		SVC		svc_wrsec
		ENDMAC	WRITESEC

WRITESSC	MACRO	buffer,drive,cylinder,sector
			
; WRSSC svc_54 will pass a function code 14 to a disk driver. 
; It is used to write a system sector (directory cylinder). 
; Disk controller must support IBM Data Address Mark convention.
; Controller command should denote "deleted data mark", or X'F8' in lieu of standard data mark (X'FB'). 
; This distinct mark is used in @RDSEC command to detect presence of a system (directory) sector. 
; Other than this Data Address Mark variation, @WRSSC is the same as @WRSEC.
; DOS will use @WRSSC for all writes to a directory cylinder. 

; Registers Affected: AF [Note: DOS saves BC, IY; drivers should save any other registers they use].

; Entry:

; C Contains the logical drive number. 
; D Contains the number of the cylinder to write. 
; E Contains the number of the sector to write. 
; HL A pointer to the buffer containing the sector of data.

; Exit.

; A Will contain the error code if an error was encountered.
; Z Set if the operation was successful.

		ld		hl,buffer
		ld		c,drive
		ld		d,cylinder
		ld		e,sector
		SVC		svc_wrssc
		ENDMAC	WRITESSC