ping		macro	ping_exit,ping_error
		scope

; This section of code tests if server available.
; After sending "@ping<CR>" this code tests for reply "@pong<CR>"
; Only tests if server available, connected & responding.

		scrollaway 26

		put.DSP.LINE $ping_screen$				; Tell operator this is ping program.

		get.DCB $UART1$,ping_error

		put.DSP.LINE $ping_da_ping$				; Report pinging server.

		put.IO	($UART1$),6,$ping_string$,ping_error		; Send ping string to server @ping LF.asc.

		put.DSP.LINE $ping_sent$				; Report starting ping to server.

$test_reply	get.IO	($UART1$),1,$pong_buff,$no_pong			; Get byte from UART1. On timeout or error goto no_pong.
		ld	a,'@'
		ld	hl,$pong_buff					; Is 1st char @ control code?
		ld	c,(hl)
		cp	a,c
		JR     	NZ,$test_reply					; Ignore if not control char & continue getting chars.

		get.IO	($UART1$),5,$pong_buff+1,$no_pong		; get 5 bytes into pong_buff, if timout or error goto no pong.

		CMP.bytes 6,$pong$,$pong_buff,$no_pong			; Compare 'pong' to pong_buffer. If <> goto no_pong.
		put.DSP.LINE $reply_rx$					; Report received @pong from server.
		GOTO	$ping_exit

$no_pong	pop	hl						; Discard error trap address.
		put.DSP.LINE $no_pong_rec$				; Tell operator no reply recieved.

$ping_exit	GOTO	ping_exit

; Strings & data used by ping command.


$UART1$		device.U1.DCB 1

$ping_string$	db	"@ping",LF.asc,ETX.asc
$ping_sent$	db	" Ping sent, waiting for reply.",CR.asc
$ping_screen$	db	" ----> Ping server <----",CR.asc
$ping_da_ping$	db	" Pinging server.",CR.asc
$reply_rx$	db	" Reply received.",CR.asc
$no_pong_rec$	db	" No reply to ping.",CR.asc
$pong$		db	"@pong",LF.asc
$pong_buff	db	"@","12345 "
		endmac	ping