; UART 1 macros.



UART1.dtr.set	macro
		scope
		in0	a,(UART1_MCTL)		; Get current register status.
		or	1			; Set bit 0 to 1.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART1.dtr.set

UART1.dtr.reset	macro
		scope
		in0	a,(UART1_MCTL)
		and	0FEh			; Strip out bit 0 making reset.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART1.dtr.reset

UART1.get.byte	macro	vector			; Get char from UART1 via driver.
		scope
		ld	a,1
		or	a			; On timeout or error goto vector.
		scf
		GOSUB	U1DVR			; C flag set & NZ set means PUT.
		IF_NE_GOSUB	vector		; If nz we had a timeout or other error.
		endmac	UART1.get.byte

UART1.get.bytes	macro	count,buffer,vector	; # bytes to get, to buffer, vector on error or timeout.
		scope
		ld	b,count			; Input 5 bytes.
		ld	hl,buffer		; Get address of buffer.
$1		UART1.get.byte	vector		; Get byte from UART1. If timeout goto no_pong.
		ld	(hl),c			; Store char.
		inc	hl
		LOOP	$1			; Loop for count bytes.
		endmac	UART1.get.bytes

UART1.mctl.put	macro	payload
		scope
		LD	A,payload		; Get payload to write in MCTL register.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART1.mctl.put

UART1.put.byte	macro	vector			; Get char from UART1 via driver.
		scope
		xor	a			; Set Z flag set means PUT.
		GOSUB	U1DVR			; Call UART driver.
		IF_NE_GOSUB vector		; If error goto error routine.
		endmac	UART1.put.byte

UART1.put.bytes	macro	count,buffer,vector
		scope
		ld	b,count			; Were sending "count" bytes.
		ld	hl,buffer
$1		ld	c,(hl)
		inc	hl
		UART1.put.byte	vector		; If nz we had a timeout or other error.
		LOOP	$1
		endmac	UART1.put.bytes
UART1.rts.set	macro
		scope
		in0	a,(UART1_MCTL)		; Get current register status.
		or	2			; Set bit 0 to 1.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART1.rts.set

UART1.rts.reset	macro
		scope
		in0	a,(UART1_MCTL)
		and	0FDh			; Strip out bit 0 making reset.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART1.rts.reset

UART1.tst.cts	macro	wait_loop		; Test CTS signal on UART 1.
		scope
		IN0	a,(UART1_MSR)		; Get CTS status & test if CTS is ready..
		BIT	4,A			; If other end sets CTS true, they are ready to receive.
		jr	z,wait_loop		; Loop until ready.
		endmac	UART1.tst.cts

UART1.tst.dcd	macro
		scope
		IN0	a,(UART1_MSR)		; Get DCD status & test if DCD is ready..
		BIT	7,A			; Test if other end sets DCD true.
		endmac	UART1.tst.dcd

UART1.tst.dsr	macro
		scope
		IN0	a,(UART1_MSR)		; Get CTS status & test if CTS is ready..
		BIT	5,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	UART1.tst.dsr

UART1.tst.ri	macro
		scope
		IN0	a,(UART1_MSR)		; Get Ring Indicator & test.
		BIT	6,A			; Test RI.
		endmac	UART1.tst.ri

UART1.tst.rx	macro	wait_loop
		scope
		IN0    	A,(UART1_LSR)		; Char waiting?
		AND	UART_DR			; 1 or TRUE if yes.
		jr	z,wait_loop		; Loop if not ready.
		endmac	UART1.tst.rx

UART1.tst.tx	macro	wait_loop
		scope				; Test UART 1 if xmitter buffer empty and ready.
		IN0 	A,(UART1_LSR)
		AND    	UART_THRE		; Returning a NE or <> 0 means ready, 0 means not ready.
		jr	z,wait_loop
		endmac	UART1.tst.tx