; UART 0 macros.



UART0.dtr.reset	macro
		scope
		in0	a,(UART0_MCTL)		; Get current register status.
		and	11111110b		; Set bit 0 to 1.
		OUT0	(UART0_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART0.dtr.reset
UART0.dtr.set	macro
		scope
		in0	a,(UART0_MCTL)		; Get current register status.
		or	1			; Set bit 0 to 1.
		OUT0	(UART0_MCTL),A		; UART1 tell other end we are ready.
		endmac	UART0.dtr.set

UART0.tst.cts	macro				; Test CTS signal on UART 0.
		scope
		IN0	a,(UART0_MSR)		; Get CTS status & test if CTS is ready..
		BIT	4,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	UART0.tst.cts

UART0.tst.dcd	macro
		scope
		IN0	a,(UART0_MSR)		; Get DCD status & test if DCD is ready..
		BIT	7,A			; Test if other end sets DCD true.
		endmac	UART0.tst.dcd

UART0.tst.dsr	macro
		scope
		IN0	a,(UART0_MSR)		; Get CTS status & test if CTS is ready..
		BIT	5,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	UART0.tst.dsr

UART0.tst.ri	macro
		scope
		IN0	a,(UART0_MSR)		; Get Ring Indicator & test.
		BIT	6,A			; Test RI.
		endmac	UART0.tst.ri

UART0.tst.rx	macro
		scope
		IN0    	A,(UART0_LSR)		; Char waiting?
		AND	UART_DR			; 1 or TRUE if yes.
		endmac	UART0.tst.rx

UART0.tst.tx	macro
		scope				; Test UART 1 if xmitter buffer empty and ready.
		IN0 	A,(UART0_LSR)
		AND    	UART_THRE		; Returning a NE or <> 0 means ready, 1 means ready.
		endmac	UART0.tst.tx
