DEC_32		MACRO	pointer
		scope
		ld	hl,pointer		; 32 bit interrupt counter.
		dec	(hl)			; INC LSB.
		jr	nz,end_dec_32		; Did not roll over to zero?
		inc	hl			; Bump to next digit.
		dec	(hl)			; Increase by one since we had carry from last digit.
		jr	nz,end_dec_32		; Did this digit carry?	
		inc	hl			; Bump pointer to next digit.
		dec	(hl)			; Increase counter by 1.
		jr	nz,end_dec_32		; Test if that increase caused carry to next column.
		inc	hl			; Bump ponter to next column.
		dec	(hl)			; INC MSB of 32 bit 4 byte counter if needed.
end_dec_32	EQU	$
		ENDMAC	DEC_32			; End of macro.
			
DECHEX		MACRO	mystring
		ld	hl,mystring
		SVC	svc_dechex
		ENDMAC	DECHEX
	
DIV16:		MACRO	arg1,arg2
		ld	hl,arg1
		ld	c,arg2
		SVC	svc_div16
		ENDMAC
			
DIV8:		MACRO	arg1,arg2
		ld	e,arg1
		ld	c,arg2
		SVC	svc_div8
		ENDMAC

HEXDEC:		MACRO	valu, result
		ld	hl,valu
		ld	de,result
		SVC	svc_hexdec
		ENDMAC	HEXDEC

INC_32		MACRO	pointer
		scope
		ld	hl,pointer		; 32 bit interrupt counter.
		inc	(hl)			; INC LSB.
		jr	nz,end_inc_32		; Did not roll over to zero?
		inc	hl			; Bump to next digit.
		inc	(hl)			; Increase by one since we had carry from last digit.
		jr	nz,end_inc_32		; Did this digit carry?	
		inc	hl			; Bump pointer to next digit.
		inc	(hl)			; Increase counter by 1.
		jr	nz,end_inc_32		; Test if that increase caused carry to next column.
		inc	hl			; Bump ponter to next column.
		inc	(hl)			; INC MSB of 32 bit 4 byte counter if needed.
end_inc_32	EQU	$
		ENDMAC	INC_32			; End of macro.
			
MUL16:		MACRO	multiplicand, multiplier
		ld	hl,multiplicand
		ld	c,multiplier
		SVC	svc_mul16
		ENDMAC

MUL8:		MACRO	multiplicand, multiplier
		ld	c,multiplicand
		ld	e,multiplier
		SVC	svc_mul8
		ENDMAC
