CMP.bytes	MACRO	length,buff1,buff2,nomatch ; Compare buffers. If <> goto nomatch.	
		scope
		ld	b,length		; Setup to compare length bytes.
		ld	hl,buff1		; Get address of first buffer.
		ld	de,buff2		; Get address of second buffer.
$1		ld	a,(de)			; Get a byte from rbuffer.
		cp	(hl)			; Compare to other buffer.
		IF_NE_GOTO	nomatch		; If compare fails match.
		inc	hl			; Advance pointers for 
		inc	de			; both buffers.
		LOOP	$1			; Loop until B=0
		endmac	CMP.bytes

cvt_ascii	macro	cvt_buff
		ld	hl,cvt_buff
		ld	c,a
		and	0f0h				; Strip out upper 4 bits.
		rr	a
		rr	a
		rr	a
		rr	a
		and	0fh
		add	'0'
		cp	':'				; Is it >9
		IF_GT_GOTO	$no_more2
		add	7				; Adjust for A-F
$no_more2	ld	(hl),a
		inc	hl
		
		ld	a,c
		and	0fh
		add	'0'
		cp	':'				; Is it >9
		IF_GT_GOTO	$no_more1	
		add	7				; Adjust for A-F
$no_more1	ld	(hl),a
		inc	hl
		ld	(hl),SP.asc
		endmac	cvt_ascii

PUT.char	macro	PUT_dcb,char,on_error
		ld	de,PUT_dcb
		ld	c,char
		SVC	svc_put
		IFMA 	3
		JP	nz,on_error		; Returned with error.
		else
		ENDIF
		endmac	PUT.char
			
STRING.kbd.get	MACRO	buffer,max
		scope
		ld	hl,buffer
		ld	b,max			; Max number bytes to input.
		ld	c,0
		SVC	svc_keyin
		endmac	STRING.kbd.get		

STRING.table.get MACRO	index,table,output
		scope
		ld	a,index			; Index value of get (1-127) to accumulator.
		dec	a
		add	a,a			; index=index*2.
		ld	e,a
		ld	d,0			; d=0 e=index*2.
		ld	hl,table		; Get base address of table.
		add	hl,de			; Point hl to index table.
		ld	bc,(hl)			; Pickup indexed pointer to entry.
		ld	hl,bc
		ld	bc,(hl)			; 1st word of entry which is length of entry.
		inc	hl			; Bump past length.
		inc	hl			; Bump past length and leave hl pointing to entry.
		ld	de,output		; Point DE to receiver place for data.
		LDIR				; Copy BC bytes from (HL) to (DE).
		ENDMAC	STRING.table.get

;STRING.table.put MACRO	index,table,input
;		scope
;		ld	a,index			; Index value of put (1-127).
;		dec	a			; index=index-1.
;		add	a,a			; index=index*2.
;		ld	e,a
;		ld	d,0
;		ld	hl,table		; Get base address of table.
;		add	hl,de			; Add offset & point hl to table entry.
;		ld	bc,(hl)			; Pickup pointer to entry.
;		ld	hl,bc
;		ld	bc,(hl)			; 1st word of entry which is length of entry.
;		inc	hl			; Bump past length.
;		inc	hl			; Bump past length and leave hl pointing to entry.
;		ld	de,hl			; Point DE to receiver place for data.
;		ld	hl,input		; Get pointer to input.
;		LDIR				; Copy BC bytes from (HL) to (DE).
;		ENDMAC	STRING.table.put

ZEROS_RPL_SPACE	macro	buffer
		ld	hl,buffer		; Get address of buffer to scan & convert.
		ld	d,'0'			; 0 to replace space.
		ld	a,' '			; Test for space.
		ld	b,5			; Test 5 char string.
$1		cp	(hl)
		jr	nz,$2			; Replace all spaces with 0's.
		ld	(hl),d
$2		inc	hl
		LOOP	$1
		endmac	ZEROS_RPL_SPACE