; UART 1 macros.


reset.UART1.DTR	macro
		scope
		in0	a,(UART1_MCTL)
		and	0FEh			; Strip out bit 0 making reset.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	reset.UART1.DTR

reset.UART1.RTS	macro
		scope
		in0	a,(UART1_MCTL)
		and	0FDh			; Strip out bit 0 making reset.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	reset.UART1.RTS
set.UART1.DTR	macro
		scope
		in0	a,(UART1_MCTL)		; Get current register status.
		or	1			; Set bit 0 to 1.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	set.UART1.DTR

set.UART1.MCTL	macro	payload
		scope
		LD	A,payload		; Get payload to write in MCTL register.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	set.UART1.MCTL

set.UART1.RTS	macro
		scope
		in0	a,(UART1_MCTL)		; Get current register status.
		or	2			; Set bit 0 to 1.
		OUT0	(UART1_MCTL),A		; UART1 tell other end we are ready.
		endmac	set.UART1.RTS

test.UART1.CTS	macro	wait_loop		; Test CTS signal on UART 1.
		scope
		IN0	a,(UART1_MSR)		; Get CTS status & test if CTS is ready..
		BIT	4,A			; If other end sets CTS true, they are ready to receive.
		jr	z,wait_loop		; Loop until ready.
		endmac	test.UART1.CTS

test.UART1.DCD	macro
		scope
		IN0	a,(UART1_MSR)		; Get DCD status & test if DCD is ready..
		BIT	7,A			; Test if other end sets DCD true.
		endmac	test.UART1.DCD

test.UART1.DSR	macro
		scope
		IN0	a,(UART1_MSR)		; Get CTS status & test if CTS is ready..
		BIT	5,A			; Test if other end sets CTS true, they are ready to receive.
		endmac	test.UART1.DSR

test.UART1.RI	macro
		scope
		IN0	a,(UART1_MSR)		; Get Ring Indicator & test.
		BIT	6,A			; Test RI.
		endmac	test.UART1.RI

test.UART1.RX	macro	wait_loop
		scope
		IN0    	A,(UART1_LSR)		; Char waiting?
		AND	UART_DR			; 1 or TRUE if yes.
		jr	z,wait_loop		; Loop if not ready.
		endmac	test.UART1.RX

test.UART1.TX	macro	wait_loop
		scope				; Test UART 1 if xmitter buffer empty and ready.
		IN0 	A,(UART1_LSR)
		AND    	UART_THRE		; Returning a NE or <> 0 means ready, 0 means not ready.
		jr	z,wait_loop
		endmac	test.UART1.TX