get.avail.DCB		MACRO					; Get 1st empty device control block (DCB).
			ld	de,0				; Tell SVC to recover 1st empty DCB.
			SVC	svc_gtdcb	
			endmac	get.avail.DCB

get.DCB			MACRO	DCB,not_found
			ld	hl,DCB				; Get device control block (DCB).
			inc	hl
			inc	hl
			ld	de,(hl)
			SVC	svc_gtdcb
			IF_NE_GOSUB not_found
			ld	(DCB),hl			; Store DCB pointer to UART1 in DCB container.	
			endmac	get.DCB

get.DCT			MACRO	num				; Get DCT for num (0-7).
			ld	c,num
			SVC	svc_gtdct
			endmac	get.DCT				; Return address of DCT in IY register.

get.ECI			macro
			FLAGS.get
			ld	a,(IY+zEFLAG$)			; Get ECI value.
			endmac	get.ECI

put.ECI			MACRO   value             		; SET ECI FLAG TO value.
       			get.FLAGS	          		; GET FLAGS POINTER IN IY.
        		LD      A,value            		; GET VALUE.
        		LD      (IY+zEFLAG$),A    		; STORE VALUE.
        		ENDMAC	put.ECI

get.FLAGS		MACRO
			scope
			SVC	svc_flags
			ENDMAC	get.FLAGS

get.MODULE		macro	name,not_found
			scope
			ld	de,name
			inc	de
			inc	de
			SVC	svc_gtmod
			IF_NE_GOSUB	not_found
			ld	(name),hl			; Store pointer to module.
			endmac	get.MODULE