cvt.HEX.ASCII		macro	cvt_buff
			ld	hl,cvt_buff
			ld	c,a
			and	0f0h				; Strip out upper 4 bits.
			rr	a
			rr	a
			rr	a
			rr	a
			and	0fh
			add	'0'
			cp	':'				; Is it >9
			IF_GT_GOTO $no_more2
			add	7				; Adjust for A-F
$no_more2		ld	(hl),a
			inc	hl
		
			ld	a,c
			and	0fh
			add		'0'
			cp	':'				; Is it >9
			IF_GT_GOTO $no_more1	
			add	7				; Adjust for A-F
$no_more1		ld	(hl),a
			inc	hl
			ld	(hl),SP.asc
			endmac	cvt.HEX.ASCII
; On entry.
; Location is a pointer to string in memory.
; Terminator is value search is terminated on when finding in string.

; On exit.
; A = terminator byte.
; HL = Pointer to terminator byte.
; BC = Count of bytes from beginning or length in 2s complement.

find.BYT		macro	location,terminator
			scope

			ld	a,terminator			; Stop counter if hitting this.
			ld	hl,location			; Pointer to data.1
			ld	bc,0				; Start counter @ 00.
$1:			cpi					; Compare (HL) to A...HL=HL+1, BC=BC-1.
			IF_NE_BRANCH $1				; If now byte were looking for loop.
			dec	hl
			endmac	find.BYT

get.STR.TBL		MACRO	index,table,output
			scope
			ld	a,index				; Index value of get (1-127) to accumulator.
			dec	a
			add	a,a				; index=index*2.
			ld	e,a
			ld	d,0				; d=0 e=index*2.
			ld	hl,table			; Get base address of table.
			add	hl,de				; Point hl to index table.
			ld	bc,(hl)				; Pickup indexed pointer to entry.
			ld	hl,bc
			ld	bc,(hl)				; 1st word of entry which is length of entry.
			inc	hl				; Bump past length.
			inc	hl				; Bump past length and leave hl pointing to entry.
			ld	de,output			; Point DE to receiver place for data.
			LDIR					; Copy BC bytes from (HL) to (DE).
			ENDMAC	get.STR.TBL
		
mov.STR			MACRO	source,destination		; Move string... LENGTH.STRING.
			scope
			ld	hl,source+2			; P/U source address.
			ld	bc,(source)			; Get address of string$
			ld	(destination),bc		; Store length in destination string.
			ld	de,destination+2		; Get destination to DE.
			LDIR					; Move a block of bytes from (HL) to (DE) until BC=0
			ENDMAC	mov.STR

put.STR.TBL		MACRO	index,table,input
			scope
			ld	a,index				; Index value of put (1-127).
			dec	a				; index=index-1.
			add	a,a				; index=index*2.
			ld	e,a
			ld	d,0
			ld	hl,table			; Get base address of table.
			add	hl,de				; Add offset & point hl to table entry.
			ld	bc,(hl)				; Pickup pointer to entry.
			ld	hl,bc
			ld	bc,(hl)				; 1st word of entry which is length of entry.
			inc	hl				; Bump past length.
			inc	hl				; Bump past length and leave hl pointing to entry.
			ld	de,hl				; Point DE to receiver place for data.
			ld	hl,input			; Get pointer to input.
			LDIR					; Copy BC bytes from (HL) to (DE).
			ENDMAC	put.STR.TBL

cvt_ZEROS2SPACE		macro	buffer
			ld	hl,buffer			; Get address of buffer to scan & convert.
			ld	d,'0'				; 0 to replace space.
			ld	a,' '				; Test for space.
			ld	b,5				; Test 5 char string.
$1			cp	(hl)
			jr	nz,$2				; Replace all spaces with 0's.
			ld	(hl),d
$2			inc	hl
			LOOP	$1
			endmac	cvt_ZEROS2SPACE