get.IO			macro	module_dcb,count,buffer,on_error
			scope				
			ld	b,count				; Pickup number of bytes to get.
			ld	hl,buffer			; Address of buffer to store chars.
			ld	de,module_dcb			; DCB of device performing GET.
$1			SVC	svc_get				; Perform GET.
			IF_NE_GOSUB on_error			; If error CALL error routine.
			ld	(hl),a				; Store char.
			inc	hl				; Bump pointer + 1.
			LOOP	$1				; Loop until all bytes read.
			endmac	get.IO

put.CHAR		macro	PUT_dcb,char,on_error
			ld	de,PUT_dcb
			ld	c,char
			SVC	svc_put
			IFMA 	3
			JP	nz,on_error			; Returned with error.
			else
			ENDIF
			endmac	put.CHAR


put.IO			macro	device,count,fm__pointer,on_error
			scope
			ld	b,count				; Were sending "count" bytes.
			ld	hl,fm__pointer
$1			ld	c,(hl)
			inc	hl
			ld	de,device			; Get pointer to DCB in DE.
			SVC	svc_put				; Send byte using put.
			IF_NE_GOSUB on_error			; If error goto error routine.
			LOOP	$1
			endmac	put.IO

put.IO.MSG		macro	dev_dcb,buffer,on_error		; Output a message line to device.
			scope
			ld	de,dev_dcb			; Get pointer to output device control block.
			ld	hl,buffer			; Buffer with line to output.
			SVC	svc_msg				; OS sends message to device.
			IF_NE_GOTO on_error			; Vector if error.
			endmac	put.IO.MSG

put.LOG.MSG		macro	buffer,on_error			; Log message in buffer to system log.
			scope
			ld	hl,buffer
			SVC	svc_loger			; Log message.
			IF_NE_GOTO on_error
			endmac	put.LOG.MSG

put.LOG.MSG.DSP		macro	buffer,on_error			; Log message to system log & display.
			scope
			ld	hl,buffer
			SVC	svc_logot
			IF_NE_GOTO on_error			; GOTO if error on logging.
			endmac	put.LOG.MSG.DSP
			
get.KBD.STRING		MACRO	buffer,max
			scope
			ld	hl,buffer
			ld	b,max				; Max number bytes to input.
			ld	c,0
			SVC	svc_keyin
			endmac	get.KBD.STRING		

get.TABLE.STRING MACRO	index,table,output
			scope
			ld	a,index				; Index value of get (1-127) to accumulator.
			dec	a
			add	a,a				; index=index*2.
			ld	e,a
			ld	d,0				; d=0 e=index*2.
			ld	hl,table			; Get base address of table.
			add	hl,de				; Point hl to index table.
			ld	bc,(hl)				; Pickup indexed pointer to entry.
			ld	hl,bc
			ld	bc,(hl)				; 1st word of entry which is length of entry.
			inc	hl				; Bump past length.
			inc	hl				; Bump past length and leave hl pointing to entry.
			ld	de,output			; Point DE to receiver place for data.
			LDIR					; Copy BC bytes from (HL) to (DE).
			ENDMAC	get.TABLE.STRING