			NEWPAGE
			SUBTITLE    "< Equates supporting multiple serial ports, memory, video, languages - OS BUILDs. >"
			scope

; < Assignments for OS assembly/build. >

; < Serial port assignments. >

DEVICE.console		EQU	0	; Serial port to use as console.
DEVICE.serialnet	EQU	1	; Serial port to use for serial networking.


DEVICE.console.baud	EQU	230400	; Starting console baudrate.
DEVICE.serialnet.baud	EQU	230400	; Starting UART1 baudrate.

f91_console_baud	EQU 	((_SYS_CLK_FREQ / DEVICE.console.baud) /16)	; Default baud rate for f91.
f92_console_baud	EQU 	((20000000 / DEVICE.console.baud) /16)		; Default baud rate for f92.

f91_serialnet_baud	EQU 	((_SYS_CLK_FREQ / DEVICE.serialnet.baud) /16)	; Default baud rate for f91.
f92_serialnet_baud	EQU 	((20000000 / DEVICE.serialnet.baud) /16)	; Default baud rate for f92.

; < Systems terminal refresh updates. >

video_refresh		EQU	3		; Refresh counter rate. 60hz is divided by video_refresh & determines updates. 3 = 20 times second.
pump_retard		EQU	20		; Initial amount to delay when pump 1st started. 0 makes max ticks of clock, 256.


; < Memory map/assignments for OS build. >

START$			EQU	0000h			; Base offset of conditional assembly.

CRTBGN$ 		EQU    	zspace.VIDEO$		; 1920 bytes video / keyboard RAM.
CRTEND$  		EQU     zspace.VIDEO$+CRTSIZE-1

DIRBUF$ 		EQU    	COREMAX$-100h  		; File buffer.

COREMAX$		EQU   	START$+2400h		; Start of application area when no library zone used.
COREMIN$		EQU   	START$+3000h		; Start of application area with active library area.
COREEND$		EQU	INTERRUPT.handler-0ch	; End+1 of usable memory for high memory routines.

ENDRAM$			EQU	10000H-1

; < Version flags ultralite, lite, standard and advanced. >

zULITE			EQU	TRUE			; HIGH memory F400h-FFFFh contains video, no bank switching.
zLITE			EQU	FALSE			; No bank RAM, full video RAM switching
zSTANDRD		EQU	FALSE			; Supports video and bank RAM as standard M4.
zADVANCD		EQU	FALSE			; STANDRD features plus bank memory to 256*32K banks.

; < Country codes. >

zINTL   		EQU	FALSE
zUSA    		EQU	TRUE

; < Language flags. >

zCZECH			EQU	FALSE
zDEUTSCH		EQU	FALSE
zENGLISH		EQU	TRUE
zFRENCH			EQU	FALSE
zGERMAN			EQU	zDEUTSCH

; < Hardware platform specific equates. >

;_EZ80ACCLAIM!		EQU	1

HEART_RATE		EQU	60

zHZ50			EQU	FALSE
zHZ60			EQU	TRUE

zMOD2			EQU	FALSE
zMOD4			EQU	FALSE
zMOD5			EQU	TRUE

; <TRSDOS versions flags.> 

zBLD631			EQU	TRUE
zBLD631C		EQU	TRUE
zBLD631D		EQU	TRUE
zBLD631E		EQU	TRUE
zBLD631F		EQU	TRUE
zBLD631G		EQU	TRUE
zBLD631H		EQU	TRUE