		SUBTITLE    <* Parameters defining memory model available to OS. *> 
		NEWPAGE
		scope

;		<* Drivers. In order KI DO PR FD S0 S1 *>

driver.KI		EQU	START$+08F0h		; Keyboard driver.	
driver.DO		EQU	START$+0B88h		; Begin video driver.		
driver.PR		EQU	START$+0E01h		; Start printer driver.
driver.FD		EQU	START$+0E3Dh		; Floppy Disk Driver entry point.
driver.S0		EQU	START$+0000h		; UART 0 driver.
driver.S1		EQU	START$+0000h		; UART 1 driver.

handler.zRST00		EQU	0000h			; IPL SVC.
handler.FDDINT$		EQU	0000h 			; NOP or DI (F3h) for
handler.zRST10		EQU	0010h
handler.zRST18		EQU	0018h
handler.zRST20		EQU	0020h
;handler.zRST28		EQU	RST28      		; System SVC processor
;handler.zRST30		EQU 	zDEBUG     		; DEBUG call address
handler.zRST38		EQU 	038h			; RST38z Interrupt RST
INTERRUPT.handler	EQU	0F600h

; These equates define storage space to position individual modules.

memory.PAGE0$		EQU	START$+0000h
memory.PAGE1$		EQU	START$+0100h
memory.PAGE2$		EQU	START$+0200h
memory.PAGE3$		EQU	START$+0300h
memory.PAGE4$		EQU	START$+0400h
memory.PAGE5$		EQU	START$+0500h

zspace.STACK$		EQU	START$+0380h		; Start of stace.

zspace.DRIVERS$		EQU	START$+08F0h		; Beginning of driver zone. KIDVR is 1st driver.

zspace.BYTEIO$		EQU	START$+1300h		; Beginning of byte I/O routines.
zspace.MEMORY$		EQU	START$+1948h		; HIGH/LOW memory functions.
zspace.SVCHANDLER$	EQU	START$+196Ah		; SVC handler.
zspace.IOFUNCTION$	EQU	START$+19F6h
zspace.RST28$		EQU	START$+1A43h		; RST28 Routine.
zspace.EXOVR$		EQU	START$+1AA0h		; Execute overlay.
zspace.SYSERROR$	EQU	START$+1AF4h		; Error executing SVC.
zspace.LOAD$		EQU	START$+1B38h		; Beginning of LOAD routine.
zspace.LOADER$		EQU	START$+1B56h		; Beginning of LOADER routine
zspace.RST38$		EQU	START$+1BFFh		; RST38 handler.
zspace.TASKER$		EQU	START$+1c94h

zspace.SYSBUF$		EQU	START$+1D00h		; System buffer, 256 byte.
zspace.OVERLAY$		EQU	START$+1E00h		; Systems overlay area, 1.5K bytes.
zspace.LIBRARY$		EQU	START$+2400h		; Library modules execution area 3072 bytes.
zspace.APPLICATION$	EQU	START$+3000h		; Application execution area, aprox 51.2K ending at COREEND$.
zspace.HIGHMEMORY$	EQU	START$+0F600h		; Begin of protected HIGH MEMORY AREA & old keyboard scan zspace..
zspace.VIDEO$		EQU	START$+0F800h		; 1920 bytes video & type ahead buffer.

quiet_default_flg	EQU	START$+3		; Holds flag for quiet & terminal type on default startup.
