		SUBTITLE	"< RST28 routine, process supervisory calls 0-127 >"
		NEWPAGE
		SCOPE

		ORG		zspace.RST28$

SVCUSER		CP		26		;Check for zERROR
		JR		Z,ERRSVC	;Skip next if so
		LD		(LSVC$),A	;Store SVC request
		EX		(SP),HL		;P/u RET address
		LD		(SVCRET$),HL	;and save it
		EX		(SP),HL		;Restore RET address
ERRSVC		PUSH		HL		;Save HL
		RLCA				;Multiply by two
		LD		H,SVCTAB$>>8	;Base of table
		LD		L,A		;Set up the low order
		LD		A,(HL)		;P/u table entry
		INC		L
		LD		H,(HL)
		LD		L,A
		EX		(SP),HL		;P/u HL & stuff vector
		LD		A,C		;Xfer for PUT type ops
		RET

;	RST 28 vector - System & user SVCs

RST28		OR		A		;Test if bit 7 set
		JP		P,SVCUSER	;Jump on user SVC attempt
		EX		(SP),HL		;Discard return addr &
		PUSH		AF		;save HL, AF
		LD		HL,zDBGHK	;Set up DEBUG linkage
		LD		A,(HL)
		LD		(SETzEXEC),A
		LD		(HL),0C9h
		POP		AF		;Restore AF, HL
		POP		HL
HKRES$		CALL		CKMODz		;Get overlay if needed
		LD		A,0		;P/u new overlay #
OVRLYOLD	EQU		$-1
		LD		(OVRLY$),A	;& update current
TRANSFR		CALL		0		;Traadr of SYSx
		PUSH		AF
		LD		A,0		;Set to C9 if EXEC only
SETzEXEC	EQU		$-1
		LD		(zDBGHK),A
		POP		AF
		RET

;	DOS command overlay request

CKMODz		PUSH		HL
		LD		H,A		; Save command value
		LD		A,B
		LD		(EXOVR2+1),A	; Set overlay #
		LD		A,H
		OR		1		; Set for SYS6 & SYS7
		CP		89h		; Is it either?
		LD		A,H		; Get back the correct #
		JR		Z,EXOVR		; Sys6/7 req? Use ISAM!
		CP		8Ah		; Sys8 also ISAM
		JR		Z,EXOVR
		LD		A,(OVRLY$)	; P/u current overlay
		XOR		H		; Ck if it"s the one
		AND		0Fh		; we need to execute
		LD		A,H
		LD		(OVRLYOLD),A	; Update current tempy
		LD		HL,1E00h	; Init to SYSx entry
		JR		Z,EXOVR3	; Go exec if resident