			SUBTITLE	"< SYSRES Page 2 >"
			newpage
			scope
			
			ORG   		memory.PAGE2$

;       	Page 2 - Device Control Blocks.

BUR$    	DB      00h             ; Bank use RAM.
BAR$    	DB      0feh            ; Bank available RAM.
LBANK$  	DB      20              ; Dir cyl & logical bank.
JCLCB$  	DB      1		; Mini-DCB for JCL gets.
		dw	0		; Pointer to input JCL FCB.
DVRHI$  	DW      DVREND$		; Start of low I/O zone.

; 		Keyboard Device Control Block.

KIDCB$ 		DB      5               ;Permit CTL, GET
       		DW		KIDVR
        	DB      0,0,0,"KI"

; 		Display output Device Control Block (Video).

DODCB$  	DB      7               ;Permit CTL, PUT, GET
        	DW      DODVR
			DB      0,0,0,"DO"

; 		Printer Device Control Block.

PRDCB$  	DB      6               ;Permit CTL, PUT
        	DW      PRDVR
        	DB      0,0,0,"PR"
			
; 		Standard input, Device Control Block.

SIDCB$  	DB      15h             ;Routed to *KI
        	DW      KIDCB$
        	DB      0Dh,0,0,"SI"

; 		Standard output, Device Control Block.
		
SODCB$ 		DB      17h             ;Routed to *DO
        	DW      DODCB$			;DODCB$
        	DB      0Fh,0,0,"SO"

; 		Job control Device Control Block.

JLDCB$  	DB      0Ah
			dw	0
			db	0Ah,0,0,"JL"


U0DCB$  	DB      7               ;Permit CTL, PUT, GET
        	DW      U0DVR
        	DB      00h,0,0,"CL"
			
U1DCB$  	DB      7               ;Permit CTL, PUT, GET
        	DW      U1DVR
        	DB      00h,0,0,"U1"


; Spare Device Control Block.

S1DCB$  	EQU     $               ;1st spare DCB

DCBKL$  	EQU     JLDCB$&0FFh+1   ;Non-killable DCB"s
