		SUBTITLE	"< IOFUN routines. >"
		NEWPAGE
		scope

		ORG	zspace.IOFUNCTION$
			
IOFUNC		PUSH	BC		;Save reg pair
		LD	B,A		;Xfer the function code			

; Bring up bank 0
			
		PUSH	BC
		xor	a
		LD	B,A		;Set bank function 0,
		LD	C,A		;bank number 0
		CALL	zBANK		;Bring up bank
		POP	AF		;Perform EX (SP),BC
		PUSH	BC
		PUSH	AF
		POP	BC
			
;	Continue disk I/O setup

		LD	A,C		;Xfer the drive code
		LD	(LDRV$),A
		PUSH	IY
		CALL	zGTDCT		;Get DCT address in IY
		LD	A,20h		;Set illegal drive #
		OR	A		;if drive disabled
		CALL	GODOIO
		POP	IY

;	Bring back the old bank

		POP	BC
		PUSH	AF		;Save disk I/O retcod
		LD	A,102		;Set for zBANK
		RST	40		;No need to ck for error
					;from zBANK
		POP	AF
		POP	BC
		RET

GODOIO		JP	(IY)
	
zGTDCT		PUSH	HL		;Get i/o routine addr
		CALL	DCTFLDz		;into IY
		EX	(SP),HL
		POP	IY
		RET	

;	Entry to get DCT+8 of FCB (IX) drive spec


DzFBYT8		LD	C,(IX+6)	;P/u drive

;	Entry to get DCT+8 of Reg C drive spec

DCTBYT8z	LD	A,8

;	Entry to get byte (Reg A) from DCT of Reg C drive
;	 C => logical drive specification
;	 A => relative byte requested from DCT
;	 A <= data at position requested

zDCTBYT		PUSH	HL		;Save the register pair
		LD	H,A
		CALL	DCTFLDz		; Get HL pointing to
		LD	L,A		; DCT position.
		LD	A,(HL)		;Get the byte
		POP	HL
		RET			
			
;	Entry to get HL pointing to DCT byte Reg C, Reg A
;	 C => logical drive number
;	 A => relative byte in DCT requested
;	HL <= start of requested DCT for the drive
;	 A <= low order pointer to relative byte request

DCTFLDz		ld	a,c		; Drive # to A.
		AND	7		; strip any excess data.
		ADD	A,A		;Times 2
		LD	L,A		;  & saved
		ADD	A,A		;Times 4
		ADD	A,A		;Times 8
		ADD	A,L		;Times 10
		ADD	A,70h		;Add DCT offset from 0
		LD	L,A		;Point L to DCT low order
		ADD	A,H		;Add in rel pos desired
		LD	H,DCT$>>8	;Point H to DCT hi-order
		RET
