			org	INTERRUPT.handler	; Beginning of handler + vector table.
			ds	256			; Vector table 192 bytes for f91 or 96 bytes for f92 will be relocated to
							; this block of memory on IPL.
			org	INTERRUPT.handler+256	; Start of actual interrupt handler code.

f91_TIMER1.handler	equ	$
f92_TIMER1.handler	equ	$

			push	af			; Save register pairs used in background tasker.
			push	hl
			push	bc
			push	de		

			INC_32	int_tmr1_cnt		; Beat 32 bit heart counter (located below).

; At this point if Z flag is set then we have a winner winner of our best chicken liver dinner.
; Livers wrapped in bacon & fried crisp served with salad, mashed potatoes, mixed veggies and a roll.
; If Z flag set it means system has been up long enough that interrupts @ 60 times per second has overflowed our 32 bit counter.
; It would take years of uptime to roll this counter over.

; IF Z = this 32 bit counter has now rolled over to 0000 0000h.
		
wp_check		ld	a,(TIMSL$)		; Here we will check if vol 0 should be write protected. If yes ensure WP bit is on.
			cp	0FFh			; System fast or slow? Fast=55, slow=FF
			IF_EQ_BRANCH	pump_check	; If drive does not need WP, branch.
			ld	hl,DCT0$+3		; Address of drive 0 DCT WP byte.
			set 	7,(hl)			; Turn ON WP.

pump_check		call	pump_switch		; Dudes this is it, check switch & video pump counter, see if she needs pumping in UART0.

			ld	a,(PFLAG$)		; Determine which processor we are on (F91 or F92)?
			sra	a			; Unpack.
			cp	01h			; PFLAG$ was set to 91h or 92h on IPL depending on processor.
			jr	z,f91tmr1ack		; Were running on f91. Handle it like a 91.

			in0	a,(f92_TMR1_CTL)	; OK, so were a 92. Handle it like were a 92, read to reset interrupt.
			jr	call_rst38		; Skip past eZ80f91 code to reset interrupts.	
	
f91tmr1ack		in0	a,(TMR1_IIR)		; eZ80f91 read to reset.
					
call_rst38		ld	hl,INTIM$		; Tell TRSDOS wakeup, PRT1 fired with 60hz interrupt using Interrupt latch image.
			set	5,(hl)

			pop	de
			pop	bc
			pop	hl
			pop	af			; Restore registers.
							; GOTO TRSDOS interrupt subsystem & execute.
			GOTO	RST38z			; Then back to what we were doing before interrupted.
							; There is no return.

pump_switch		RETURN				; This changes to NOP then pump video enabled, if RET then pump is off.
			ld	a,(pumpcnt)		; Get pump counter. If video RAM has been accessed, then inc counter.
			dec	a			; Counter=counter-1.
			ld	(pumpcnt),a		; Store it back.
			ret	nz			; Counter did NOT reach 0 thus do NOT pump video to console.

			ld	a,0c9h			; Get RET instruction, turn pump routine OFF.
			ld	(pump_switch),a		; Make this pump then disable pump until ENADIS_DO_RAM routine reenables again.

			ld	a,video_refresh		; Get value & reset counter.
			ld	(pumpcnt),a		; Reset counter to countdown value.

			ld	hl,zspace.VIDEO$-9	; Point to video RAM.
			ld	de,CRTSIZE+2		; Size of video screen in dec (1920).

canisend1		IN0	a,(UART0_MSR)		; Get CTS status & test if CTS is ready..
			BIT	4,A			; If other end sets CTS true, they are ready to receive.I just
			JR	Z,canisend1		; If not ready wait. Come on I am waiting in CANISND loop.

			IN0	A,(UART0_LSR)		; Find out if UART ready to transmit.
			cpl
			AND    	UART_THRE		; Determine if our own UART is ready to send a character.
			jr	nz,canisend1		; Loop until we can send.

			
			ld	a,(zDFLAG$)		; Bit 7 contains graphic bit.
			BIT	7,a			; Test graphic bit. If on pass graphic unchanged.
			ld	a,(hl)			; Get char to display.
			
			IF_NE_BRANCH	pass_grap

			BIT	7,A			; Test if this char >=$80h.
			IF_EQ_BRANCH	non_grap	; <$80h then branch.

			ld	a,' '			; Change char >=$80h to ascii space.
pass_grap
non_grap		OUT0  	(UART0_THR),a		; Out the UART our character goes.....wheeee!!!!

			inc	hl			; Bump pointer to next char.
			dec	de			; Counter - 1.

			ld	a,d			; Test if counter rolled over to 0.
			or	e			; If both registers 0 then flag will be Z.
			IF_EQ_RETURN			; Thank you we are finished pumping!
			jr	canisend1		; Loop if more chars to dump.

int_tmr1_cnt 		db	0			; Heartbeat counter holding 1/60th counts of uptime.
			db	0
			db	0
			db	0

pumpcnt			db	pump_retard		; Counter to pump video RAM to terminal. Pump every x countdown.
pump_switch_value db	0C9h				; Start off with RET or C9h, this prevents pump from pumping.


EMAC.RX.handler
EMAC.TX..handler
EMAC.SYS.handler
PLL.handler
FLASH.handler
TIMER0.handler
;TIMER1.handler
TIMER2.handler
TIMER3.handler
TIMER4.handler
TIMER5.handler
RTC.handler
UART0.handler
UART1.handler
I2C.handler
SPI.handler
PORT.A.BIT0.handler
PORT.A.BIT1.handler
PORT.A.BIT2.handler
PORT.A.BIT3.handler
PORT.A.BIT4.handler
PORT.A.BIT5.handler
PORT.A.BIT6.handler
PORT.A.BIT7.handler
PORT.B.BIT0.handler
PORT.B.BIT1.handler
PORT.B.BIT2.handler
PORT.B.BIT3.handler
PORT.B.BIT4.handler
PORT.B.BIT5.handler
PORT.B.BIT6.handler
PORT.B.BIT7.handler
PORT.C.BIT0.handler
PORT.C.BIT1.handler
PORT.C.BIT2.handler
PORT.C.BIT3.handler
PORT.C.BIT4.handler
PORT.C.BIT5.handler
PORT.C.BIT6.handler
PORT.C.BIT7.handler
PORT.D.BIT0.handler
PORT.D.BIT1.handler
PORT.D.BIT2.handler
PORT.D.BIT3.handler
PORT.D.BIT4.handler
PORT.D.BIT5.handler
PORT.D.BIT6.handler
PORT.D.BIT7.handler
f92_EMAC.RX.handler
f92_EMAC.TX..handler
f92_EMAC.SYS.handler
f92_PLL.handler
f92_FLASH.handler
f92_TIMER0.handler
f92_TIMER2.handler
f92_TIMER3.handler
f92_TIMER4.handler
f92_TIMER5.handler
f92_RTC.handler
f92_UART0.handler
f92_UART1.handler
f92_I2C.handler
f92_SPI.handler
f92_PORT.A.BIT0.handler
f92_PORT.A.BIT1.handler
f92_PORT.A.BIT2.handler
f92_PORT.A.BIT3.handler
f92_PORT.A.BIT4.handler
f92_PORT.A.BIT5.handler
f92_PORT.A.BIT6.handler
f92_PORT.A.BIT7.handler
f92_PORT.B.BIT0.handler
f92_PORT.B.BIT1.handler
f92_PORT.B.BIT2.handler
f92_PORT.B.BIT3.handler
f92_PORT.B.BIT4.handler
f92_PORT.B.BIT5.handler
f92_PORT.B.BIT6.handler
f92_PORT.B.BIT7.handler
f92_PORT.C.BIT0.handler
f92_PORT.C.BIT1.handler
f92_PORT.C.BIT2.handler
f92_PORT.C.BIT3.handler
f92_PORT.C.BIT4.handler
f92_PORT.C.BIT5.handler
f92_PORT.C.BIT6.handler
f92_PORT.C.BIT7.handler
f92_PORT.D.BIT0.handler
f92_PORT.D.BIT1.handler
f92_PORT.D.BIT2.handler
f92_PORT.D.BIT3.handler
f92_PORT.D.BIT4.handler
f92_PORT.D.BIT5.handler
f92_PORT.D.BIT6.handler
f92_PORT.D.BIT7.handler

STRAY.handler		ld	a,0ffh
			ld	(int_tmr1_cnt),a
			jr	$