		SUBTITLE	"< Execute overlay requested routine. >"
		NEWPAGE
		scope
			
; Execute a system overlay.

		ORG		zspace.EXOVR$

EXOVR		PUSH		DE
		PUSH		BC
		AND		0Fh			; Get right nybble.
		BIT		3,A			; Check for SYS0-7.
		JR		Z,EXOVR1		; w/o changing carry.
		ADD		A,18h			; Adjust for sys8-15.
EXOVR1		LD		(SFCB$+7),A
		LD		B,A			; Set DEC for directory.
		LD		A,20h			; Set bit 5 of FCB+1.
		LD		(SFCB$+1),A
		SBC		HL,HL			; Carry is clear here.
		LD		(SFCB$+10),HL		; Zero NRN.
		LD		C,H			; Init for drive 0.
		CALL		zDIRRD			; Read dir entry.
		JR		NZ,EXERR		; Go if error.
		LD		A,(HL)			; Was overlay purged?
		AND		50h			; or is it non-system?
		XOR		50h
		LD		A,7			; Init "deleted error".
		JR		NZ,EXERR
		LD		A,L
		ADD		A,22			; Point to 1st extent.
		LD		L,A
		LD		DE,SFCB$+14		; Extent field in FCB.
		CALL		PAT1			; Stuff 1st two extents.
EXOVR2		LD		B,0			; P/u ISAM # or zero.
		LD		E,SFCB$&0FFh
		CALL		LOADER			; Read system overlay.
EXERR		POP		BC
		POP		DE
EXOVR3		LD		(TRANSFR+1),HL		; Stuff overlay entry point.
		POP		HL
		RET		Z
		JR		SYSERR			; Go on read I/O error

; Routine to calculate 1st two extents of SYS file.

PAT1		CALL		PAT1A			; Move first extent.
		AND		1Fh			; Compute # of granules.
		INC		A
		LD		(DE),A			; And store in FCB.
		INC		DE
		XOR		A
		LD		(DE),A
		INC		DE
PAT1A		CALL		PAT1B			; Move second extent.
PAT1B		LD		A,(HL)
		LD		(DE),A
		INC		HL
		INC		DE
		RET