		SUBTITLE	"< UART 1 - Driver.	RS-232 TERMINAL I/O subroutines. >"
		SCOPE

; Transmit byte in register C.

U1DVR		jr	U1BGN			; Driver entry point, branch around linkage.

		DW     	U1END           	; Last memory location used.
		DB     	3,"$U1"
		DW     	U1DCB$          	; DCB used.
		DW     	0			; Reserved.

U1BGN		JR	Z,TXUART1		; Go if output, PUT.
		JR	C,RXUART1		; Go if input, GET.

CTLUART1 ; CTL request - get status of char waiting & return.

		LD	A,C			; If CTL 0, return
		OR	A			; status. Else
		JR	Z,RXUART1		; treat as a Get

		UART1.tst.rx	fdc_ctl_ret	; We return ready/not ready with status.

fdc_ctl_ret	RET

RXUART1 ; GET request, UART 0 I/O subroutines to receive byte into reg A.

		ld	a,echo_delay_ct		; Setup inits for timeout timer.
		ld	(echo_timer),a
		push	de
		ld	de,0			; Inits for 65536 countdown.

		UART1.dtr.set			; Set DTR active, tell server we are here.
		UART1.rts.set			; Set RTS active tell we are ready.

RXUART1WAIT	call	uart1_timeout		; Call timeout timer, if counter reaches 0 no return.

		UART1.tst.rx	RXUART1WAIT	; loop until byte avail.

		UART1.rts.reset			; Set RTS inactive telling other end wait.

		IN0	c,(UART1_RBR)		; GET char waiting.

		pop	de			; Restore DE to value on entry.	
		ld	a,c
		cp	a			; Set Z flag to show successful completion.
		RET

TXUART1 ; Character PUT request, transmit byte in register C.

		ld	a,echo_delay_ct		; Setup inits for timeout timer.
		ld	(echo_timer),a
		push	de
		ld	de,0			; Inits for 65536 countdown.

TXUART1WAIT	call	uart1_timeout		; Call timeout timer. If this counter has reached 0 there is no return.

		UART1.tst.cts	TXUART1WAIT	; Test if UART CTS ready? If <> ready wait in loop, calling timeout timer.

		UART1.tst.tx	TXUART1WAIT	; Test if UART1 xmitter empty & ready accept data.
 
		OUT0   	(UART1_THR),C		; Send byte into the ether....so to speak.

		pop	de			; Restore DE.
		XOR	A			; A=0, no error.
		RETURN

uart1_timeout	dec	de			; count = count - 1.
		ld	a,d
		or	e
		IF_NE_RETURN			; IF 65536 timer <> 0
		ld	a,(echo_timer)		; Initialize DE in case we go another round.
		dec	a			; Timer = timer - 1.
		ld	(echo_timer),a
		IF_NE_RETURN			; If timer <> 0, return.		
		pop	de			; Discard return address in driver.
		pop	de			; Restore register to entry of driver.
		ld	a,1
		or	a			; Make NZ.
		RETURN				; Return with error.

echo_delay_ct	equ	25			; Single source to change delay for assembly.
echo_timer	db	echo_delay_ct		; Holds counter when running timer for timeout detection.

U1END:		EQU	$-1			