		SUBTITLE	"< Real Time Clock interrupt processor - maintaining date/time via software >"
		newpage
	    	SCOPE

; Time clock - Real Time Clock interrupt processor.

TIMTSK$		LD	A,(CRSAVE)		;If cursor not on,
		OR	A			;then don"t blink
		LD	HL,VFLAG$		;Point to video flag
		jr	z,$?2		;z,

; Check if cursor needs blinking blink if so.

		BIT	7,(HL)			; Check system INHIBIT blinking.
		RES	7,(HL)			; Allow blink next time
		JR	NZ,$?2			; Branch around cursor blink.
		INC	(HL)			; Increment the counter
		BIT	3,(HL)			; Test if = 8
		JR	Z,$?2			; IF <> 8 branch
		RES	3,(HL)			; IF counter=8 then counter=0.
		BIT	6,(HL)			; BLINK/SOLID cursor test.

		JR	nZ,$?2		;NOSOLID		; Branch for blink.
		nop						; nop to fill memory locations & retain length.
		nop			;SET	5,(HL)		; Force SOLID mode.

NOSOLID		CALL	ENADIS_DO_RAM		; Bring up the video RAM
		LD	A,(HL)			; Grab the toggle bit
		XOR	20h			; and flip it
		LD	(HL),A
		AND	20h			; Was it on?
		LD	DE,(CURSOR)		; Get the cursor pos
		LD	A,(CRSAVE)		; and char under cursor
		JR	NZ,$?1			; Put character if flip on
		LD	A,(CRSCHAR)		; else put the cursor
$?1		LD	(DE),A			; Put the char
$?2		BIT	4,(HL)			; Is clock on (VFLAG$)?
		JR	Z,$?3			; OFF? Go if OFF..
		LD	DE,CLOCK		; Set to display clock
		PUSH	DE
$?3		ret

		LD	(IX+3),30		; Reset for one second
HERTZ$		EQU	$-1