; TOD - Time of Day Clock.

		JR	GETDATE			; Driver entry point. Branch around linkage
		DW      RTCEND$			; Last memory location used
		DB      6,"RTCDVR"
		DW      0			; DCB used.
		DW      0

GETDATE		RTC.YEAR.get	a		; Get year.
		call	bcd2bin
		add	100			; DATE is stored in excess 1900.
		ld	(DATE$),a		; Store years in excess of 1900.

		RTC.DOM.get	a		; Get day of month.
		call	bcd2bin
		ld	(DATE$+1),a		; Get day of month in binary from RTC.

		RTC.MON.get	a		; Get month in binary from RTC.
		call	bcd2bin
		LD	(DATE$+2),a		; Point DE to DATE buffer end.

		LD	DE,DATE$+2
		ret
		
GETTIME		RTC.HOUR.get	a		; Get hour in binary from RTC.
		call	bcd2bin
		ld	(TIME$+2),a
		
		RTC.MIN.get	a
		call	bcd2bin
		ld	(TIME$+1),a

		RTC.SEC.get	a
		call	bcd2bin
		ld	(TIME$),a

		LD	DE,TIME$+2		;Point to time$
		RET

;*****************************
;	 a(BIN) =>  a(BCD) 
;	[0..99] => [00h..99h]
;*****************************

bin2bcd		push	bc
		ld	b,10
		ld	c,-1
div10:		inc	c
		sub	b
		jr	nc,div10
		add	a,b
		ld	b,a
		ld	a,c
		add	a,a
		add	a,a
		add	a,a
		add	a,a
		or	b
		pop	bc
		ret
;****************************
;	a(BCD) => a(BIN) 
;	[00h..99h] -> [0..99]
;****************************

bcd2bin:	push	bc
		ld	c,a
		and	0f0h
		srl	a
		ld	b,a
		srl	a
		srl	a
		add	a,b
		ld	b,a
		ld	a,c
		and	0fh
		add	a,b
		pop	bc
		ret
			
RTCEND$		EQU	$-1




