; This section of code tests if server available.

; After sending "@ping<CR>" this code tests for reply "@pong<CR>"

; Only tests if server available, connected & responding.

query_server	GOSUB	scrolloff

		PUMP	DEVICE.console,query_screen$	; Tell operator this is ping program.
		PUMP	DEVICE.console,query_start$	; Report starting query to server.

		PUMP	DEVICE.serialnet,query_command$	; Send query string to server @rhdr LF.asc.

		UART1.get.bytes 0,query_buffer,query_timeout ; Query server, get 256 bytes >buffer & vector on timeout.

		PUMP	DEVICE.console,query_replied$

		MVC	query_buffer,query_srv_type,8	; Put server type in this program menu.
		MVC	query_buffer,nettyp$,8		; Put server type in main IPL menu.

		MVC	query_buffer+11,DCT6$+3,7	; Move DiskDisk DCT to net drive 6 DCT.

		ld	a,(DCT6$+3)			; Make sure WP off.
		RES	7,a				; Reset WP.
		ld	(DCT6$+3),a

		ld	a,(DCT6$+4)			; Drive 1.
		and	0F0h				; Strip out drive select bits.
		set	0,a				; Make this drive #1.
		set	4,a				; Tell world this is an alien controller.
		set	6,a				; Capable of double density.
		ld	(DCT6$+4),a
		xor	a				; Update DCT, its way it is on real model 4.
		ld	(DCT6$+5),a			; Cylinder=0.

;	Now read track=0 sector=0 of NETdrive.
; 	Recover directory cylinder pointer.

		MVC	query_zeros$,query_rd_sector+1,5 ; Make sure command lines are all 0's.

		ld	de,0				; 1st sector.
		HEXDEC	de,query_rd_sector+1		; Convert 16 bit address to ascii in network command.

		ld	hl,query_rd_sector+1		; Convert all spaces in string to 0's.
		GOSUB	zeros_rpl_space1


		PUMP	DEVICE.serialnet,query_rd_sector ; Command server to send directory sector.
		UART1.get.bytes 0,query_buffer,query_timeout ; Read directory sector from server, 256 bytes>buffer & vector on timeout.

		ld	a,(query_buffer+2)		; Get pointer to directory & place in DCT1
		ld	(DCT6$+9),a			; directory pointer, pointing to true directory cylinder.

		ld	a,(DCT6$+3)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct3$),a
		ld	a,c
		ld	(query_dct3$+1),a

		ld	a,(DCT6$+4)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct4$),a
		ld	a,c
		ld	(query_dct4$+1),a

		ld	a,(DCT6$+5)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct5$),a
		ld	a,c
		ld	(query_dct5$+1),a

		ld	a,(DCT6$+6)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct6$),a
		ld	a,c
		ld	(query_dct6$+1),a

		ld	a,(DCT6$+7)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct7$),a
		ld	a,c
		ld	(query_dct7$+1),a

		ld	a,(DCT6$+8)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct8$),a
		ld	a,c
		ld	(query_dct8$+1),a

		ld	a,(DCT6$+9)			; Convert to byte to hex ascii XX.
		GOSUB	query_cvt_ascii
		ld	a,b
		ld	(query_dct9$),a
		ld	a,c
		ld	(query_dct9$+1),a

;<-------------->

;		PUMP	DEVICE.console,query_buffer	; Tell operator this is ping program.

		ld	a,(DCT6$+4)			; Test if double sided drive?
		ld	d,a
		ld	a,(DCT6$+7)			; Get sectors per track.
		AND	1Fh				; Strip out sectors per track only.
		inc	a				; Adjust to actual sectors per track.
		bit	5,d
		jr	z,query_not_dbl			; NO, skip doubling sectors per track.
		sla	a				; A = A * 2, double sided - double sectors per trk.
query_not_dbl	ld	d,a				; Store in D.
		ld	a,(DCT6$+9)			; Get directory cylinder.
		ld	e,a				; Dir cylinder.
		mlt	de				; sector = cylinder * sectors per track.
		
		HEXDEC	de,query_rd_sector+1		; Convert 16 bit address to ascii in network command.

		ld	hl,query_rd_sector+1		; Convert all spaces in string to 0's.
		GOSUB	zeros_rpl_space1

		PUMP	DEVICE.serialnet,query_rd_sector	; Command server to send directory sector.

		UART1.get.bytes 0,query_buffer,query_timeout	; Read directory sector from server, 256 bytes>buffer & vector on timeout.
		
		MVC	query_buffer+0D0h,netvol$,8		; Copy volume name to volname in main menu.
		MVC	query_buffer+0D8h,netvol$+9,8		; Copy volume creation date to main menu.
		MVC	query_buffer+0D0h,query_volnam,8	; Copy volume name into this program.
		MVC	query_buffer+0D8h,query_volnam+10,8	; Copy volume creation date.

;	Stuff ASCII disk space in main menu.

		ld	iy,DCT6$
		ld	d,(iy+6)			; Get max cylinders.
		inc	d
		ld	a,(iy+7)			; Get config, lower nibble contains sec per trk.
		and	3Fh				; Get lower nibble containing sectors per trk.
		inc	a
		bit	5,(iy+4)			; Sides = 2?
		jr	z,qserv_notdbl			; If so then we double sectors per track.
		sla	a				; Sectors per track = sectors per track * 2.
qserv_notdbl	ld	e,a				; Setup to multiply track * sectors per track.
		MLT	DE				; we then multiply (# CYL * SEC per CYL) 16b result in DE.

; Following instruction changes to NOP if this is not a diskDISK image.

		inc	de			; Bump one sector higher to adjust for diskdisk header.

; Convert DE to 24 bit by  H=D, L=E, E=0    24 BIT--> E:HL.
; Convert to packed BCD.
; Convert packed BCD to unpacked.
; Convert unpacked to ASCII.
; Trim leading 0's away.
; Stuff all these results in main menu.

		ld	BC,netsiz$			; Store decimal ASCII of 24 bit value in main memu.
		call	cvt_24_ascii			; Convert 24 bit value to ASCII & stuff in main menu.

		MVC	netsiz$,query_space_fld,8 	; Place of copy of disk space in NETUTILS menu.

		GOTO	query_exit

query_timeout	pop	hl				; Discard timout trap address.
		PUMP	DEVICE.console,query_timeout$	; Report to operator query timed out.
query_exit	LD	a,0ffh
query_exit1	RETURN

query_cvt_ascii	ld	c,a
		and	0f0h				; Strip out upper 4 bits.
		rr	a
		rr	a
		rr	a
		rr	a
		and	0fh
		add	'0'
		cp	':'				; Is it >9
		IF_GT_GOTO	query_no_more2
		add	7				; Adjust for A-F
query_no_more2	ld	b,a
		ld	a,c
		and	0fh
		add	'0'
		cp	':'				; Is it >9
		IF_GT_GOTO	query_no_more1	
		add	7				; Adjust for A-F
query_no_more1	ld	c,a
		RETURN

zeros_rpl_space1 ld	d,'0'				; 0 to replace space.
		ld	a,' '				; Test for space.
		ld	b,5				; Test 5 char string.
qry_rpl_spaces1	cp	(hl)
		jr	nz,qry_by11			; Replace all spaces with 0's.
		ld	(hl),d
qry_by11	inc	hl
		LOOP	qry_rpl_spaces1
		RETURN

query_screen$	DB	" Query server for network volume.",CR.asc,CR.asc,ETX.asc

query_start$	db	" Sending server query command.",CR.asc
		db	" Waiting for server to reply...",CR.asc,ETX.asc

query_replied$	db	" Server replied...",CR.asc,ETX.asc
query_timeout$	db	" Server did not reply to query.",CR.asc,ETX.asc

query_command$	db	"@rhdr",LF.asc,ETX.asc		; Get header for volume.

query_buffer	ds	256				; Buffer to hold query i/o.
		db	CR.asc,ETX.asc

query_rd_sector	db	"<00000",LF.asc,CR.asc,ETX.asc

query_zeros$	db	"00000"


;query_8space	db	"        "
		db	ETX.asc				; End of screen.
