; This section of code tests if server available.

; After sending "@ping<CR>" this code tests for reply "@pong<CR>"

; Only tests if server available, connected & responding.

ping_server	GOSUB	scrolloff

		PUMP	DEVICE.console,ping_screen$	; Tell operator this is ping program.
		PUMP	DEVICE.console,ping_da_ping$	; Report pinging server.

;		UART1.dtr.set				; Turn UART 1 DTR ON.
;		UART1.rts.set
		PUMP	DEVICE.serialnet,ping_string$	; Send ping string to server @ping LF.asc.
;		UART1.rts.reset

		PUMP	DEVICE.console,ping_sent$	; Report starting ping to server.

test_reply	UART1.get.byte	no_pong			; Get byte from UART1. On timeout or error goto no_pong.
		ld	a,'@'				; Is 1st char @ control code?
		cp	c				; Compare to C, C has char from GET_BYTE_UART1.
		JR     	NZ,test_reply			; Ignore if not control char & continue getting chars.

;		UART1.rts.set
		UART1.get.bytes	5,pong_buff+1,no_pong	; get 5 bytes into pong_buff, if timout or error goto no pong.
;		UART1.rts.reset

		CMP.bytes 6,pong$,pong_buff,no_pong	; Compare 'pong' to pong_buffer. If <> goto no_pong.
		MVC	server_avail,server_stat,12	; Change server to show available.
		PUMP	DEVICE.console,reply_rx$	; Report received @pong from server.
		GOTO	ping_exit

no_pong		pop	hl				; Discard error trap address.
		MVC	server_not,server_stat,12	; Change server to show available.
		PUMP	DEVICE.console,no_pong_rec$	; Tell operator no reply recieved.

ping_exit	ld	a,0ffh
		RETURN

; Strings & data used by ping command.

ping_string$	db	"@ping",LF.asc,ETX.asc

ping_sent$	db	" Ping sent, waiting for reply.",CR.asc,ETX.asc

ping_screen$	db	CR.asc," ----> Ping server <----",CR.asc,ETX.asc

ping_da_ping$	db	" Pinging server.",CR.asc,ETX.asc

ping_end_line$	db	CR.asc,ETX.asc

reply_rx$	db	CR.asc," Reply received.",CR.asc,ETX.asc

no_pong_rec$	db	CR.asc," No reply to ping.",CR.asc,ETX.asc

pong$		db	"@pong",LF.asc

pong_buff	db	"@","12345 "

server_avail	db	"Available   "