; This section of code sends a 256 byte pack to server.
; After sending packet this app waits for reply & compares packet received to packet sent.
; Program then reports if compare was equal or not.

; This is only used to test if server connected, running and responding.

echo_server	GOSUB	scrolloff


		PUMP	DEVICE.console,echo_screen$	; Report to operator this program performs @echo.
		PUMP	DEVICE.console,try_echo$	; Tell operator sending @echo packet to server.

		PUMP	DEVICE.serialnet,echo_string$	; Send @echo LF.asc packet.

;		UART1.mctl.put	00000001b		; Set DTR active, RTS inactive telling over end were ready.

		UART1.put.bytes	0,echo_xmit_buff,echo_no_reply ; @echo & 256 byte packet has been sent.

;		UART1.mctl.put	00000001b		; Set DTR inactive, RTS inactive, telling server we are ready.

		PUMP	DEVICE.console,packet_sent$	; Tell operator packet sent.


; Server echos back packet we sent. Receive that packet now.



		UART1.get.bytes	0,echo_rec_buff,echo_no_reply

;		ld	b,0
;		ld	hl,echo_rec_buff
;echo_get_byte;	UART1.mctl.put	00000011b		; Set DTR active, RTS active tell we are ready.

;echo_RXUART1WAIT UART1.tst.rx	echo_RXUART1WAIT	; loop until byte avail.

;		UART1.mctl.put	00000001b		; Set DTR active, RTS inactive telling other end wait.

;		IN0	c,(UART1_RBR)			; GET char waiting.
;		ld	(hl),c				; Store char.
;		inc	hl
;		LOOP	echo_get_byte			; 

;		UART1.mctl.put	00000001b		; Set DTR active, RTS inactive telling server we are ready..

; 256 byte packet has been received back from server.

		PUMP	DEVICE.console,echo_rx$		; Report to operator packet received
		PUMP	DEVICE.console,echo_compare$	; Tell operator beginning comparing sent packet to received packet.

		CMP.bytes 0,echo_xmit_buff,echo_rec_buff,echo_no_match ; CMP 256 byte buffers, if <> then goto echo_no_match.

; If we arrive here, both buffers match.

echo_match	PUMP	DEVICE.console,echo_match$	; Report to operator contents of both packets match.
		GOTO	askforenter			; After operator presses enter, exit this program.

echo_no_match	PUMP	DEVICE.console,echo_no_match$	; Report to operator contents of packets DOES NOT match.
		GOTO	askforenter			; After operator presses enter, exit this program.

echo_no_reply	PUMP	DEVICE.console,echo_no_reply$	; Tell operator no reply.
		pop	hl				; Discard return vector where error happened.
askforenter	ld	a,0ffh
		RETURN					; Return to calling main IPL menu.

; Strings used by network echo command.


echo_string$	db	"@echo",LF.asc,ETX.asc

echo_screen$	db	" Command server to echo packet back from client.",CR.asc,ETX.asc

try_echo$	db	" Sending packet to server.",CR.asc,ETX.asc

packet_sent$	db	" @echo packet sent.",CR.asc,CR.asc,ETX.asc

echo_rx$	db	" Reply packet received.",CR.asc,CR.asc,ETX.asc

echo_compare$	db	" Comparing packet sent to packet received.",CR.asc,ETX.asc

echo_match$	db	" $$$PASS$$$ Packet sent matches packet received.",CR.asc,ETX.asc

echo_no_match$	db	" $$$FAIL$$$ Packet sent does NOT match packet received.",CR.asc,ETX.asc

echo_no_reply$	db	CR.asc, " No reply from server.",CR.asc,ETX.asc

echo_xmit_buff 	db	"The456789a1quick789b12brown89c123fox789d1234jumped12345overf123456theg1234567lazy2345678dogs3456789back456789k123456789l123456789m123456789n123456789o123456789p123456789q123456789r123456789s123456789t123456789u123456789v123456789w123456789x123456789y123456"

echo_rec_buff	ds	256				; Buffer to hold ping/RX/TX data.