RTC_IPL		call		scrolloff
		MVC		screenbuf,dowbuff+3,9	; Always start with a fresh buffer by stuffing with spaces.
		DATE.get	DATEBUF	
		TIME.get	TIMEBUF
		call		getdow
		STRING.table.get	A,DOWTABLE,DOWBUF
		PUMP		DEVICE.console,screenbuf	
prompt		call		getchar
		cp		ESC.asc			; If <CR> only return to main menu.
		jp		z,main_ipl_menu
		cp		'1'			; Check is operator wants to change DATE.
		jp		z,cngdat
		cp		'2'			; Check is operator wants to change day of week.
		jp		z, cngdow
		cp		'3'			; Test of operator wants to change time.
		jp		z,cngtim

		jp		prompt

cngdat		call		scrolloff
		DATE.get	cdat
		PUMP		DEVICE.console,edtdatscn
cngmon		PUMP		DEVICE.console,gtmon
		INPUT_U.str	editbuffer,2
		PUMP		DEVICE.console,CR$
		DECHEX		editbuffer
		ld		a,c
		or		a
		jp		z,cngmon
		cp		13
		jp		nc,cngmon
		ld		(savmon),a
		HEXDEC		BC,cngmo
cngday		PUMP		DEVICE.console,gtday
		INPUT_U.str	editbuffer,2
		PUMP		DEVICE.console,CR$
		DECHEX		editbuffer
		ld		a,c
		or		a
		jp		z,cngday
		cp		32
		jp		nc,cngday
		ld		(savday),a
		HEXDEC		BC,cngdy
cngcen		PUMP		DEVICE.console,gtcen
		INPUT_U.str	editbuffer,2
		PUMP		DEVICE.console,CR$
		DECHEX		editbuffer
		ld		a,c
		or		a
		jp		z,cngcen
		cp		100
		jp		nc,cngcen
		ld		(savcen),a
		HEXDEC		BC,cngcn
cngyear		PUMP		DEVICE.console,gtyear
		INPUT_U.str	editbuffer,2
		PUMP		DEVICE.console,CR$
		DECHEX		editbuffer
		ld		a,c
		or		a
		jp		z,cngyear
		cp		100
		jp		nc,cngyear
		ld		(savyr),a
		HEXDEC		BC,cngyr	
			
cngprompt	PUMP		DEVICE.console,cngmsg
cngget		KEY_U.get	
		cp		ESC.asc
		jp		z,RTC_IPL
		cp		EOT.asc
		jr		nz,cngget
		RTC.unlock
		ld		a,(savday)
		call		bin2bcd
		RTC.DOM.put	a
		ld		a,(savmon)
		call		bin2bcd
		RTC.MON.put	a
		ld		a,(savyr)
		call		bin2bcd
		RTC.YEAR.put	a
		ld		a,(savcen)
		call		bin2bcd
		RTC.CEN.put	a
		RTC.lock

		PUMP		DEVICE.console,cngcomplete
regetrsp1	KEY_U.get	
		cp		CR.asc
		JP		z,RTC_IPL
		jp		regetrsp1
		
cngdow		call		scrolloff
		MVC		screenbuf,dowbuff+3,9		; Always start with a fresh buffer by stuffing with spaces.
		call		getdow
		PUMP		DEVICE.console,dowprompt
;		PUMP		DEVICE.console,cngmsg
			
dspdow		FOR		1,7,1				; Loop thru all 7 days of week.
		LD		a,c
		ld		(savcntr),a
		add		'0'				; Convert to ASCII.
		ld		(dowbuff),a			; Stuff ASCII character (1-7) in buffer.
		ld		a,'.'				; Follow number with a .
		ld		(dowbuff+1),a
		ld		a,' '
		ld		(dowbuff+2),a			; Place a space in buffer after number and period.				
		MVC		screenbuf,dowbuff+3,9		; Always start with a fresh buffer by stuffing with spaces.
		STRING.table.get (savcntr),DOWTABLE,dowbuff+3
		PUMP		DEVICE.console,dowbuff
		NEXT		dspdow
		PUMP		DEVICE.console,getadow$

		KEY_U.get	A
		cp		ESC.asc
		jp		z,RTC_IPL
		ld		(dowbuff),a
		sub		'0'				; Convert number from ASCII to binary.
		ld		(savdow),a
		jp	z,cngdow
		or	A					; Zero not allowed.
		cp	8					; Test if greater than 7.
		jp	z,cngdow
		jp	nc,cngdow
		call	scrolloff
		MVC	screenbuf,dowbuff+3,9			; Always start with a fresh buffer by stuffing with spaces.
		STRING.table.get (savdow),DOWTABLE,dowbuff+3
		PUMP	DEVICE.console,downew
		PUMP	DEVICE.console,dowbuff+3
		PUMP	DEVICE.console,cngdowverify

		KEY_U.get	
		cp	ESC.asc
		jp	z,RTC_IPL
		cp	EOT.asc
		jp	nz,cngdow
		RTC.unlock
		RTC.DOW.put	(savdow)
		RTC.lock
		PUMP	DEVICE.console,cngcomplete
regetrsp2	KEY_U.get	
		cp	CR.asc
		JP	z,RTC_IPL
		jp	regetrsp2			

cngtim		call	scrolloff
		PUMP	DEVICE.console,cngtimscrn
		PUMP	DEVICE.console,cnghrsprompt
		INPUT_U.str editbuffer,2
		ld	a,b
		PUMP	DEVICE.console,CR$

		DECHEX	editbuffer			; Convert ASCII in buffer to binary.
		ld	a,c				; Binary results are in BC. We only need lower 8 bits.
		cp	24				; Make sure hours <24.
		jp	nc,cngtim			; Branch if 24 or >.
		ld	(savhrs),a			; We have a new hours so save in hour buffer.
		HEXDEC	BC,cnghr			; BC still has binary, convert ascii & stuff in menu.

; Prompt change minutes.
			
cngmn		PUMP	DEVICE.console,cngminprompt	; Get minutes in ascii
		INPUT_U.str	editbuffer,2		; into editbuffer.
		ld	a,b				; I think this does nothing.
		PUMP	DEVICE.console,CR$

		DECHEX	editbuffer			; Convert 2 digit buffer to binary.
		ld	a,c				; Results in BC.
		cp	60				; > 59?
		jp	nc,cngmn			; Jump if so.
		ld	(savmin),a			; Else save into minutes.
		HEXDEC	BC,cngmin			; Convert binary BC to ASCII & stuff in menu.

; This will display all changes in a small menu.
; Menu prompts for ^D confirm or ESC abort.

		PUMP	DEVICE.console,cnghrsnew
		KEY_U.get
		CP	ESC.asc				; ABORT?
		JP	z,RTC_IPL			; Yes? Return to main IPL menu.
		cp	EOT.asc				; ^D?
		jp	nz,cngtim			; If not keep prompting for new time until abort or save.

; Code to change physical time clock is here.

		RTC.unlock
		ld	a,(savhrs)
		call	bin2bcd
		RTC.HOUR.put	a
		ld	a,(savmin)
		call	bin2bcd
		RTC.MIN.put	a
		ld	a,(savsec)
		call	bin2bcd	
		RTC.SEC.put	a
		RTC.lock
			
		PUMP	DEVICE.console,cngcomplete
regetrsp3	KEY_U.get
		JP	RTC_IPL

getdow		RTC.DOW.get	A
		and		7			; Strip all but lower 3 bits (0-7).
		or		a			; Test if not initialized and happens to have a 0.
		jr		nz,itsnot0		; It is not a 0, thus between 1-7 (Sun-Sat).
		ld		a,1			; Make it Sunday.
itsnot0		ret		