		SUBTITLE	"< POST - Power On Self Test >"
		NEWPAGE
		SCOPE
			
POST		equ		$				; Application testing OS calls.

		CLS
		DISPLAY		SVC105DATA			; Test SVC 105.
		ld		hl,ipltst			; Test SVC #  0 IPL.
		ld		(zRST00+1),hl
		IPL
ipltst:		DISPLAY		SVC0IPL

		DISPLAY		SVC1KEY
		DISPLAY		pressenter
retrycr		KEY.get						; Test SVC #  1 KEY.
		cp		CR.asc
		jr		nz,retrycr			
		PUT		CR.asc,U0DCB$

DISPLAY		SVC2DSP						; Test SVC #  2 DSP.

			
		DISPLAY		getakey				; Test SVC #  3 GET.
regetkey	CHAR.get	U0DCB$
		cp			'.'
		jr		nz,regetkey

		DISPLAY		SVC3GET
		PUT			CR.asc,U0DCB$
		DISPLAY		SVC4PUT				; Test SVC #   4 PUT.
		PUT		'O',U0DCB$
		PUT		'K',U0DCB$
		PUT		CR.asc,U0DCB$
;		PUT		LF.asc,U0DCB$

		PRT.char	'A'				; Test SVC #  6 PRT.
		DISPLAY		SVC6PRT	

		WHERE						; Test SVC #  7 WHERE.
		DISPLAY		SVC7WHERE

		DISPLAY		SVC8SCANKB			; Test SVC #  8 SCANKB.

		DISPLAY		nameprompt
		INPUT.str	name,180
		DISPLAY		SVC9KEYIN

tmptmp		DISPLAY		SVC10DATA			; Test SVC 10 DISPLAY.

		MSG		SVC13MSG,U0DCB$			; Test SVC 13 MSG.

		DISPLAY		SVC14DATA			; Test SVC 14 PRINT. 
		PRT.msg		SVC14DATA

		DISPLAY		SVC15VDCTL			; Test SVC 15 Video Control.
		LD		A,15
		LD		B,7
		LD		C,6
		RST		28H
	
		DISPLAY		SVC16DATA			; Test SVC 16, PAUSE
		PAUSE		1

		DATE		date1$				; Test SVC 18, DATE.
		DISPLAY		SVC18DATE

		TIME		time1$				; Test SVC 19, TIME.
		DISPLAY		SVC19TIME


; *****>>>>> Begin drive tests <<<<<*****

		DISPLAY		SVC33DATA			; SVC 33 CKDRV.
		CKDRIVE		0,FAILSVC33

		DISPLAY		SVC33PASS
		JR		SVC34
FAILSVC33	DISPLAY		SVC33FAIL

			
SVC34		DISPLAY		SVC34DATA			; SVC 34 DODIR
		VIEWDIR		0,SVC34BUF

SVC40		DCSTATUS	0,dcstaterr			; SVC 40 DCSTAT
		DISPLAY		SVC40DATA
		jr		selectdrv
dcstaterr	DISPLAY		SVC40err

selectdrv	SELECT		0,selerror			; SVC 41 SELECT DRIVE.
		DISPLAY		SVC41DATA
		jr		dcinit
selerror	DISPLAY		SVC41ERROR

dcinit		DCINIT		0,initerr			; SVC 42 Initialize drive controller drive 0.
		DISPLAY		SVC42DATA
		jr		dcreset
initerr		DISPLAY		SVC42err		

dcreset		DCRESET		0				; Reset controller attached to drive 0.
		DISPLAY		SVC43DATA			; Test SVC 43 Reset drive controller.

		RESTORE0	0				; Restore drive 0 to cylinder 0.
		DISPLAY		SVC44DATA			; Test SVC 44 restore drive to cylinder 0.		

		STEPIN		0
		DISPLAY		SVC45DATA			; Test SVC 45 issue step in to drive contrller.

		SEEKCYL		0,0				; Test SVC 46 SEEK to Cylinder on Drive.
		DISPLAY		SVC46DATA

		RESELECT	0				; Select drive until it shows ready.
		DISPLAY		SVC47DATA			; Test SVC 47 Reselect busy drive until ready.

		WRITESEC	userbuf,0,0,0			; buffer,drive,cylinder,sector
		DISPLAY		SVC53DATA			; Test SVC 53 WRITESEC.

		WRITESSC	sysbuf,0,20,1			; buffer,drive,cylinder,sector
		DISPLAY		SVC54DATA			; Test SVC 54 WRITE SYSTEM SECTOR.

		READ.hdr	DISKBUF48,0			; buffer,drive
		DISPLAY		SVC48DATA			; Test SVC 48. READ HEADER  read a sector from drive.
		DISPLAY		DISKBUF48

		READ.sec	diskbuf49,0,0,0			; buffer,drive,cylinder,sector
		DISPLAY		SVC49DATA			; Test SVC 49. READSEC  read a sector from drive.
		DISPLAY		diskbuf49

		DCT.get		A				; Retrive DCT for drive 0.
		HEXDEC		IY,DCT0
		DISPLAY		SVC81DATA			; TEST SVC 81, GETDCT.
		DISPLAY		DCT0

		READ.ssc	diskbuf85,0,20,1		; buffer,drive,cylinder,sector
		DISPLAY		SVC85DATA			; Test SVC 85 READ SYSTEM SECTOR.
		DISPLAY		diskbuf85

		DISPLAY		SVC87DATA
		ld		b,0
		ld		c,0
			
tst87		PUSH		BC
		ld		c,b
		ld		b,0
		HEXDEC		BC,RDDIRRESULT
		MVC		failmsg,rddirresult,4
		pop		bc
		push		bc
		READ.dir	b,0,TST87DN
		MVC		passmsg,rddirresult,4

TST87DN		DISPLAY		RDDIRRESULT
		POP		BC	
		INC		B
		ld		a,b
		cp		7
		JR		NZ,tst87
			
;	*****>>>>> Math / Conversion tests <<<<<*****

		MUL8		2,2				; Test SVC 90, MUL8
		DISPLAY		SVC90DATA

		MUL16		2,2				; Test SVC 91, MUL16
		DISPLAY		SVC91DATA

		DIV8		4,4				; Test SVC 93, DIV8.
		DISPLAY		SVC93DATA

		DIV16		8,8				; Test SVC 94, DIV16.
		DISPLAY		SVC94DATA			; Test SVC 95. 

		DECHEX		answer1$			; Test SVC 96, DECHEX
		DISPLAY		answer$
		DISPLAY		passY

		HEXDEC		08001h,result1$			; Test SVC 97, HEXDEC.
		DISPLAY		SVC97DATA

		FLAGS.get
		DISPLAY		SVC101DATA			; Test SVC 101, GETFLAGS.
		LD		(SVC101DATA),a
		DISPLAY		result1$

		LD		C,3				; Test SVC 102 BANK,
		BANK		2


;	*****>>>>> SOUND tests <<<<<*****

		SOUND		0,0				; Test SVC 104, SOUND.
		DISPLAY		SVC104DATA

		DISPLAY		endoftst			; Report end of OS SVC diagnostics.

getaenter	KEY.get
		cp		CR.asc
		jr		nz,getaenter
		jp		mainmenu
			
PROB:		DISPLAY		PROBLEM
		RET

DCT0:		BLKB		9,0
DCT1:		BLKB		9,0
DCT2:		BLKB		9,0
DCT3:		BLKB		9,0
DCT4:		BLKB		9,0
DCT5:		BLKB		9,0
DCT6		BLKB		9,0
DCT7:		BLKB		9,0
	
passY:		db			" passed.",CR.asc,ETX.asc
passN:		db			" FAILED. ",CR.asc,ETX.asc	
getakey		db			"SVC #3   GET test, GET function. PRESS-->'.' ",ETX.asc
pressenter	db			"Press <ENTER> ",ETX.asc
nameprompt	db			"Please enter your name: ",CR.asc,LF.asc	

SVC0IPL:	db			"SVC #0   IPL test, passed.",CR.asc,ETX.asc		
SVC1KEY:	db			"SVC #1   KEY test, passed.",ETX.asc	
SVC2DSP:	db			"SVC #2   DSP test, passed.",CR.asc,ETX.asc
SVC3GET		db			"passed. ",ETX.asc
SVC4PUT		db			"SVC #4   PUT test, passed if word OK appears here--->",ETX.asc
SVC6PRT:	db			"SVC #6   PRTBYTE test passed.",CR.asc,ETX.asc
SVC7WHERE:	db			"SVC #7   WHERE test passed.",CR.asc,ETX.asc
SVC8SCANKB:	db			"SVC #8   SCAN KEYBOARD.",CR.asc,ETX.asc
SVC9KEYIN	db			"SVC #9   Testing KEYIN. Hello "
name		db			"                              ",CR.asc,LF.asc,ETX.asc
SVC10DATA:	db			"SVC #10  DISPLAY test passed.",CR.asc,ETX.asc
SVC13MSG:	db			"SVC #13  MSG SVC, passed.",CR.asc,ETX.asc
SVC14DATA:	db			"SVC #14  PRINT, passed.",CR.asc,ETX.asc
SVC15VDCTL	db			"SVC #15  Video Control. ",CR.asc,ETX.asc
SVC16DATA:	db			"SVC #16  PAUSE test passed.",CR.asc,ETX.asc	
SVC18DATE:	db			"SVC #18  DATE "
date1$:		db			"03/17/84 ",CR.asc,ETX.asc
SVC19TIME:	db			"SVC #19  TIME "
time1$:		db			"12:34:56 ",CR.asc,ETX.asc			

SVC33DATA	db			"SVC #33  Check drive ",ETX.asc
SVC33PASS	db			"PASS",CR.asc,ETX.asc
SVC33FAIL	db			"FAIL",CR.asc,ETX.asc
SVC34DATA	db			"SVC #34  DODIR....",CR.asc,ETX.asc
SVC34BUF	ds			256
SVC40DATA:	db			"SVC #40  DCSTAT...Passed.",CR.asc,ETX.asc
SVC40err	db			"SVC #40  DCSTAT...FAILED.",CR.asc,ETX.asc
SVC41DATA:	db			"SVC #41  SELECT DRIVE...Passed.",CR.asc,ETX.asc
SVC41ERROR:	DB			"SVC #41  SELECT DRIVE...FAILED.",CR.asc,ETX.asc
SVC42DATA:	db			"SVC #42  DCINIT - Initialize drive controller...Passed.",CR.asc,ETX.asc
SVC42err:	db			"SVC #42  DCINIT - Initialize drive controller...FAILED.",CR.asc,ETX.asc
SVC43DATA	db			"SVC #43  DCRES - Reset controller attached to drive 0....Passed.",CR.asc,ETX.asc
SVC44DATA	db			"SVC #44  RSTOR - Restore drive to CYL=0...Passed. ",CR.asc,ETX.asc
SVC45DATA:	db			"SVC #45  STEPI - Issue step in to drive controller...Passed",CR.asc,ETX.asc
SVC46DATA:	db			"SVC #46  SEEKCYL - Seek to CYL=0 on DRIVE=0...Passed.",CR.asc,ETX.asc
SVC47DATA	db			"SVC #47  RSLCT - Reselect drive until ready...Passed.",CR.asc,ETX.asc
SVC48DATA	db			"SVC #48  RDHDR - Read header...SVC not implimented.",CR.asc,ETX.asc

SVC85DATA:	db			"SVC #85  Read system sector drive=0 cyl=20 sec=0 PASSED.",CR.asc,ETX.asc
diskbuf85:	db			" ";"*** FAILED *** system sector",	CR.asc,ETX.asc
		DS			256
		db			ETX.asc	
SVC49DATA:	db			"SVC #49  Read user sector drive=0 cyl=3 sec=3 PASSED",CR.asc,ETX.asc

SVC53DATA	db			"SVC #53  Write user sector drive=0 cyl=3 sec=3.",CR.asc,ETX.asc
SVC54DATA	db			"SVC #54  Write system sector drive=0 cyl=20 sec=0.",CR.asc,ETX.asc


SVC81DATA	db			"SVC #81  Get DCT, passed. ",CR.asc, ETX.asc
SVC87DATA	db			"SVC #87  READ DIR:",CR.asc,ETX.asc
RDDIRRESULT	db			"      directory record READ "
rddirresult	db			"    ",CR.asc,ETX.asc
SVC90DATA:	db			"SVC #90  MUL8 test passed.",CR.asc, ETX.asc
SVC91DATA:	db			"SVC #91  MUL16, passed.",CR.asc, ETX.asc	
SVC93DATA:	db			"SVC #93  DIV8, passed.",CR.asc, ETX.asc
SVC94DATA:	db			"SVC #94  DIV16, passed.",CR.asc, ETX.asc
SVC96DATA:
answer$:	db			"SVC #96  DECHEX test="
answer1$:	db			"65535",ETX.asc
SVC97DATA	db			"SVC #97  HEXDEC test="	
result1$:	db			"        ",CR.asc,ETX.asc
			
SVC101DATA:	db			"SVC #101 GETFLAGS, test passed.",CR.asc,ETX.asc
SVC104DATA:	db			"SVC #104 SOUND test passed.",CR.asc,ETX.asc
SVC105DATA:	db			"SVC #105 CLS test passed.",CR.asc,ETX.asc
endoftst:	db			"End OS SVC diagnostics, press ENTER to continue.",CR.asc,ETX.asc
	
PROBLEM:	DB			"Houston we have a problem-> ",ETX.asc


sysbuf:		DB			"sucessful SVC-54",CR.asc,ETX.asc
		ds			238
userbuf:	DB			"sucessful SVC-53.",CR.asc,ETX.asc
		ds			256
DISKBUF48:	ds			255
		db			ETX.asc			
diskbuf49	db			"*** FAILED ***   user sector",CR.asc,ETX.asc
		ds			256
		db			ETX.asc
;diskbuf85	ds			256


failmsg		db			"Fail"
passmsg		db			"Pass"
			
